/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid.base;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface FluidHolder {
    @Deprecated
    public static final Codec<FluidHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257020_.m_194605_().fieldOf("fluid").forGetter(FluidHolder::getFluid), (App)Codec.FLOAT.fieldOf("buckets").orElse((Object)Float.valueOf(1.0f)).forGetter(fluidHolder -> Float.valueOf((float)fluidHolder.getFluidAmount() / (float)FluidHooks.getBucketAmount())), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(fluidHolder -> Optional.ofNullable(fluidHolder.getCompound()))).apply((Applicative)instance, (fluid, buckets, compoundTag) -> FluidHooks.newFluidHolder(fluid, FluidHooks.buckets(buckets.floatValue()), compoundTag.orElse(null))));
    public static final Codec<FluidHolder> NEW_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257020_.m_194605_().fieldOf("fluid").forGetter(FluidHolder::getFluid), (App)Codec.LONG.fieldOf("millibuckets").orElse((Object)1000L).forGetter(fluidHolder -> FluidConstants.toMillibuckets(fluidHolder.getFluidAmount())), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(fluidHolder -> Optional.ofNullable(fluidHolder.getCompound()))).apply((Applicative)instance, (fluid, millibuckets, compoundTag) -> FluidHolder.ofMillibuckets(fluid, millibuckets, compoundTag.orElse(null))));

    public static FluidHolder of(Fluid fluid) {
        return FluidHooks.newFluidHolder(fluid, FluidConstants.getBucketAmount(), null);
    }

    public static FluidHolder of(Fluid fluid, long amount) {
        return FluidHooks.newFluidHolder(fluid, amount, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.20.4")
    public static FluidHolder of(Fluid fluid, double buckets, CompoundTag tag) {
        return FluidHooks.newFluidHolder(fluid, FluidHooks.buckets(buckets), tag);
    }

    public static FluidHolder of(Fluid fluid, long amount, CompoundTag tag) {
        return FluidHooks.newFluidHolder(fluid, amount, tag);
    }

    public static FluidHolder ofMillibuckets(Fluid fluid, long millibuckets, @Nullable CompoundTag tag) {
        return FluidHooks.newFluidHolder(fluid, FluidConstants.fromMillibuckets(millibuckets), tag);
    }

    public static FluidHolder ofMillibuckets(Fluid fluid, long millibuckets) {
        return FluidHooks.newFluidHolder(fluid, FluidConstants.fromMillibuckets(millibuckets), null);
    }

    public static FluidHolder empty() {
        return FluidHooks.emptyFluid();
    }

    public static FluidHolder fromCompound(CompoundTag tag) {
        FluidHolder fluid = FluidHolder.of(Fluids.f_76191_, 0L);
        fluid.deserialize(tag);
        return fluid;
    }

    default public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_236835_(Optional.ofNullable(this.isEmpty() ? null : this), (friendlyByteBuf, fluid) -> {
            friendlyByteBuf.m_130130_(BuiltInRegistries.f_257020_.m_7447_((Object)fluid.getFluid()));
            friendlyByteBuf.m_130103_(fluid.getFluidAmount());
            friendlyByteBuf.m_130079_(fluid.getCompound());
        });
    }

    public static FluidHolder readFromBuffer(FriendlyByteBuf buffer) {
        return buffer.m_236860_(friendlyByteBuf -> {
            Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7942_(friendlyByteBuf.m_130242_());
            long amount = friendlyByteBuf.m_130258_();
            CompoundTag tag = friendlyByteBuf.m_130260_();
            return FluidHolder.of(fluid, amount, tag);
        }).orElse(FluidHolder.empty());
    }

    public Fluid getFluid();

    public void setFluid(Fluid var1);

    public long getFluidAmount();

    public void setAmount(long var1);

    public CompoundTag getCompound();

    public void setCompound(CompoundTag var1);

    public boolean isEmpty();

    public boolean matches(FluidHolder var1);

    public FluidHolder copyHolder();

    public CompoundTag serialize();

    public void deserialize(CompoundTag var1);

    default public FluidHolder copyWithAmount(long amount) {
        FluidHolder copy = this.copyHolder();
        if (!copy.isEmpty()) {
            copy.setAmount(amount);
        }
        return copy;
    }

    default public Holder<Fluid> getFluidHolder() {
        return this.getFluid().m_205069_();
    }

    default public boolean is(TagKey<Fluid> tagKey) {
        return this.getFluid().m_205067_(tagKey);
    }

    default public boolean is(Fluid fluid) {
        return this.getFluid() == fluid;
    }

    default public boolean is(Predicate<Holder<Fluid>> predicate) {
        return predicate.test(this.getFluidHolder());
    }

    default public boolean is(Holder<Fluid> fluid) {
        return this.getFluidHolder() == fluid;
    }
}

