/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.world.gen.TypedFeature;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class IafWorldData
extends SavedData {
    private static final String IDENTIFIER = "iceandfire_general";
    private static final Map<FeatureType, List<Pair<String, BlockPos>>> LAST_GENERATED = new HashMap<FeatureType, List<Pair<String, BlockPos>>>();

    public IafWorldData() {
    }

    public IafWorldData(CompoundTag tag) {
        this.load(tag);
    }

    public static IafWorldData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel overworld = world.m_7654_().m_129880_(world.m_46472_());
            DimensionDataStorage storage = overworld.m_8895_();
            IafWorldData data = (IafWorldData)storage.m_164861_(IafWorldData::new, IafWorldData::new, IDENTIFIER);
            data.m_77762_();
            return data;
        }
        return null;
    }

    public boolean check(TypedFeature feature, BlockPos position, String id) {
        return this.check(feature.getFeatureType(), position, id);
    }

    public boolean check(FeatureType type, BlockPos position, String id) {
        List entries = LAST_GENERATED.computeIfAbsent(type, key -> new ArrayList());
        boolean canGenerate = true;
        Pair toRemove = null;
        for (Pair entry : entries) {
            if (((String)entry.getFirst()).equals(id)) {
                toRemove = entry;
            }
            canGenerate = position.m_123331_((Vec3i)entry.getSecond()) > IafConfig.dangerousWorldGenSeparationLimit * IafConfig.dangerousWorldGenSeparationLimit;
        }
        if (toRemove != null) {
            entries.remove(toRemove);
        }
        entries.add(Pair.of((Object)id, (Object)position));
        return canGenerate;
    }

    public IafWorldData load(CompoundTag tag) {
        FeatureType[] types;
        for (FeatureType type : types = FeatureType.values()) {
            ListTag list = tag.m_128437_(type.toString(), 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entry = list.m_128728_(i);
                String id = entry.m_128461_("id");
                BlockPos position = NbtUtils.m_129239_((CompoundTag)entry.m_128469_("position"));
                LAST_GENERATED.computeIfAbsent(type, key -> new ArrayList()).add(Pair.of((Object)id, (Object)position));
            }
        }
        return this;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        LAST_GENERATED.forEach((key, value) -> {
            ListTag listTag = new ListTag();
            value.forEach(entry -> {
                CompoundTag subTag = new CompoundTag();
                subTag.m_128359_("id", (String)entry.getFirst());
                subTag.m_128365_("position", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)entry.getSecond())));
                listTag.add((Object)subTag);
            });
            tag.m_128365_(key.toString(), (Tag)listTag);
        });
        return tag;
    }

    public static enum FeatureType {
        SURFACE,
        UNDERGROUND,
        OCEAN;

    }
}

