/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.particle;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ParticleDragonFrost
extends TextureSheetParticle {
    private static final ResourceLocation SNOWFLAKE = new ResourceLocation("iceandfire:textures/particles/snowflake_0.png");
    private static final ResourceLocation SNOWFLAKE_BIG = new ResourceLocation("iceandfire:textures/particles/snowflake_1.png");
    private final float dragonSize;
    private final double initialX;
    private final double initialY;
    private final double initialZ;
    private double targetX;
    private double targetY;
    private double targetZ;
    private final int touchedTime = 0;
    private final float speedBonus;
    @Nullable
    private EntityDragonBase dragon;
    private final boolean big;

    public ParticleDragonFrost(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, float dragonSize) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.f_107225_ = 30;
        this.initialX = xCoordIn;
        this.initialY = yCoordIn;
        this.initialZ = zCoordIn;
        this.targetX = xCoordIn + (double)((this.f_107223_.m_188501_() - this.f_107223_.m_188501_()) * 1.75f * dragonSize);
        this.targetY = yCoordIn + (double)((this.f_107223_.m_188501_() - this.f_107223_.m_188501_()) * 1.75f * dragonSize);
        this.targetZ = zCoordIn + (double)((this.f_107223_.m_188501_() - this.f_107223_.m_188501_()) * 1.75f * dragonSize);
        this.m_107264_(this.f_107212_, this.f_107213_, this.f_107214_);
        this.dragonSize = dragonSize;
        this.speedBonus = this.f_107223_.m_188501_() * 0.015f;
        this.big = this.f_107223_.m_188499_();
    }

    public ParticleDragonFrost(ClientLevel world, double x, double y, double z, double motX, double motY, double motZ, EntityDragonBase entityDragonBase, int startingAge) {
        this(world, x, y, z, motX, motY, motZ, Mth.m_14036_((float)(entityDragonBase.getRenderSize() * 0.08f), (float)0.55f, (float)3.0f));
        this.dragon = entityDragonBase;
        this.targetX = this.dragon.burnParticleX + (double)(this.f_107223_.m_188501_() - this.f_107223_.m_188501_()) * 3.5;
        this.targetY = this.dragon.burnParticleY + (double)(this.f_107223_.m_188501_() - this.f_107223_.m_188501_()) * 3.5;
        this.targetZ = this.dragon.burnParticleZ + (double)(this.f_107223_.m_188501_() - this.f_107223_.m_188501_()) * 3.5;
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.f_107224_ = startingAge;
    }

    public void m_5744_(@NotNull VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Quaternionf quaternion;
        Vec3 inerp = renderInfo.m_90583_();
        if (this.f_107224_ > this.m_107273_()) {
            this.m_107274_();
        }
        Vec3 Vector3d = renderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - Vector3d.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - Vector3d.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - Vector3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = renderInfo.m_253121_();
        } else {
            quaternion = new Quaternionf((Quaternionfc)renderInfo.m_253121_());
            float f3 = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(f3));
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1 = quaternion.transform(vector3f1);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f = quaternion.transform(vector3f);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = 0.0f;
        float f8 = 1.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)(this.big ? SNOWFLAKE_BIG : SNOWFLAKE));
        int j = this.m_6355_(partialTicks);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexbuffer = tessellator.m_85915_();
        vertexbuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        vertexbuffer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        vertexbuffer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        vertexbuffer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        vertexbuffer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    public int m_107273_() {
        return this.dragon == null ? 10 : 30;
    }

    public int m_6355_(float partialTick) {
        float f = 0.0f;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        int i = super.m_6355_(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.dragon == null) {
            float distX = (float)(this.initialX - this.f_107212_);
            float distZ = (float)(this.initialZ - this.f_107214_);
            this.f_107215_ += (double)(distX * -0.01f * this.dragonSize * this.f_107223_.m_188501_());
            this.f_107217_ += (double)(distZ * -0.01f * this.dragonSize * this.f_107223_.m_188501_());
            this.f_107216_ += (double)(0.015f * this.f_107223_.m_188501_());
        } else {
            double d2 = this.targetX - this.initialX;
            double d3 = this.targetY - this.initialY;
            double d4 = this.targetZ - this.initialZ;
            double dist = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
            float speed = 0.015f + this.speedBonus;
            this.f_107215_ += d2 * (double)speed;
            this.f_107216_ += d3 * (double)speed;
            this.f_107217_ += d4 * (double)speed;
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }
}

