/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.clientbound;

import com.aetherteam.aether.perk.data.ClientMoaSkinPerkData;
import com.aetherteam.aether.perk.types.MoaData;
import com.aetherteam.nitrogen.network.BasePacket;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public abstract class ClientMoaSkinPacket {

    public record Sync(Map<UUID, MoaData> moaSkinsData) implements BasePacket
    {
        public void encode(FriendlyByteBuf buf) {
            buf.m_236831_(this.moaSkinsData(), FriendlyByteBuf::m_130077_, MoaData::write);
        }

        public static Sync decode(FriendlyByteBuf buf) {
            Map moaSkinsData = buf.m_236847_(FriendlyByteBuf::m_130259_, MoaData::read);
            return new Sync(moaSkinsData);
        }

        public void execute(Player playerEntity) {
            if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null && this.moaSkinsData() != null && !this.moaSkinsData().isEmpty()) {
                for (Map.Entry<UUID, MoaData> moaSkinsDataEntry : this.moaSkinsData().entrySet()) {
                    ClientMoaSkinPerkData.INSTANCE.applyPerk(moaSkinsDataEntry.getKey(), moaSkinsDataEntry.getValue());
                }
            }
        }
    }

    public record Remove(UUID playerUUID) implements BasePacket
    {
        public void encode(FriendlyByteBuf buf) {
            buf.m_130077_(this.playerUUID());
        }

        public static Remove decode(FriendlyByteBuf buf) {
            UUID uuid = buf.m_130259_();
            return new Remove(uuid);
        }

        public void execute(Player playerEntity) {
            if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null && this.playerUUID() != null) {
                ClientMoaSkinPerkData.INSTANCE.removePerk(this.playerUUID());
            }
        }
    }

    public record Apply(UUID playerUUID, MoaData moaSkinData) implements BasePacket
    {
        public void encode(FriendlyByteBuf buf) {
            buf.m_130077_(this.playerUUID());
            MoaData.write(buf, this.moaSkinData());
        }

        public static Apply decode(FriendlyByteBuf buf) {
            UUID uuid = buf.m_130259_();
            MoaData moaSkinData = MoaData.read(buf);
            return new Apply(uuid, moaSkinData);
        }

        public void execute(Player playerEntity) {
            if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null && this.playerUUID() != null && this.moaSkinData() != null) {
                ClientMoaSkinPerkData.INSTANCE.applyPerk(this.playerUUID(), this.moaSkinData());
            }
        }
    }
}

