/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.rei;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.integration.jei.categories.fuel.AetherFuelRecipeMaker;
import com.aetherteam.aether.integration.rei.AetherREIServerPlugin;
import com.aetherteam.aether.integration.rei.categories.ban.BlockBanRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.ban.ItemBanRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.ban.PlacementBanRecipeDisplay;
import com.aetherteam.aether.integration.rei.categories.block.AetherBlockStateRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.block.BiomeParameterRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.item.AetherCookingRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.item.AetherCookingRecipeDisplay;
import com.aetherteam.aether.inventory.menu.AltarMenu;
import com.aetherteam.aether.inventory.menu.FreezerMenu;
import com.aetherteam.aether.inventory.menu.IncubatorMenu;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.recipes.ban.BlockBanRecipe;
import com.aetherteam.aether.recipe.recipes.ban.ItemBanRecipe;
import com.aetherteam.aether.recipe.recipes.block.AccessoryFreezableRecipe;
import com.aetherteam.aether.recipe.recipes.block.AmbrosiumRecipe;
import com.aetherteam.aether.recipe.recipes.block.IcestoneFreezableRecipe;
import com.aetherteam.aether.recipe.recipes.block.PlacementConversionRecipe;
import com.aetherteam.aether.recipe.recipes.block.SwetBallRecipe;
import com.aetherteam.aether.recipe.recipes.item.AltarRepairRecipe;
import com.aetherteam.aether.recipe.recipes.item.EnchantingRecipe;
import com.aetherteam.aether.recipe.recipes.item.FreezingRecipe;
import com.aetherteam.aether.recipe.recipes.item.IncubationRecipe;
import com.aetherteam.nitrogen.integration.jei.categories.fuel.FuelRecipe;
import com.aetherteam.nitrogen.integration.rei.categories.fuel.AbstractFuelCategory;
import com.aetherteam.nitrogen.integration.rei.displays.BlockStateRecipeDisplay;
import com.aetherteam.nitrogen.integration.rei.displays.FuelDisplay;
import com.aetherteam.nitrogen.recipe.recipes.AbstractBlockStateRecipe;
import java.util.Collection;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

@REIPluginClient
public class AetherREIClientPlugin
implements REIClientPlugin {
    public static final ResourceLocation ALTAR_TEXTURE = new ResourceLocation("aether", "textures/gui/menu/altar.png");

    public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(ItemBanRecipe.class, (RecipeType)AetherRecipeTypes.ITEM_PLACEMENT_BAN.get(), PlacementBanRecipeDisplay::ofItem);
        registry.registerRecipeFiller(BlockBanRecipe.class, (RecipeType)AetherRecipeTypes.BLOCK_PLACEMENT_BAN.get(), PlacementBanRecipeDisplay::ofBlock);
        registry.registerRecipeFiller(AccessoryFreezableRecipe.class, (RecipeType)AetherRecipeTypes.ACCESSORY_FREEZABLE.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.ACCESSORY_FREEZABLE, (AbstractBlockStateRecipe)recipe));
        registry.registerRecipeFiller(AmbrosiumRecipe.class, (RecipeType)AetherRecipeTypes.AMBROSIUM_ENCHANTING.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.AMBROSIUM_ENCHANTING, (AbstractBlockStateRecipe)recipe));
        registry.registerRecipeFiller(IcestoneFreezableRecipe.class, (RecipeType)AetherRecipeTypes.ICESTONE_FREEZABLE.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.ICESTONE_FREEZABLE, (AbstractBlockStateRecipe)recipe));
        registry.registerRecipeFiller(PlacementConversionRecipe.class, (RecipeType)AetherRecipeTypes.PLACEMENT_CONVERSION.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.PLACEMENT_CONVERSION, (AbstractBlockStateRecipe)recipe));
        registry.registerRecipeFiller(SwetBallRecipe.class, (RecipeType)AetherRecipeTypes.SWET_BALL_CONVERSION.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.SWET_BALL_CONVERSION, (AbstractBlockStateRecipe)recipe));
        for (FuelRecipe fuelRecipe : AetherFuelRecipeMaker.getFuelRecipes()) {
            registry.add((Display)new FuelDisplay(AetherREIServerPlugin.AETHER_FUEL, (Collection)fuelRecipe.getInput(), fuelRecipe.getBurnTime(), fuelRecipe.getUsage()));
        }
        for (Object recipe2 : registry.getRecipeManager().m_44013_((RecipeType)AetherRecipeTypes.ENCHANTING.get())) {
            if (recipe2 instanceof EnchantingRecipe) {
                EnchantingRecipe enchanting = (EnchantingRecipe)((Object)recipe2);
                registry.add(AetherCookingRecipeDisplay.of(AetherREIServerPlugin.ALTAR_ENCHANTING, enchanting));
                continue;
            }
            if (!(recipe2 instanceof AltarRepairRecipe)) continue;
            AltarRepairRecipe repair = (AltarRepairRecipe)((Object)recipe2);
            registry.add(AetherCookingRecipeDisplay.of(AetherREIServerPlugin.ALTAR_REPAIR, repair));
        }
        registry.registerRecipeFiller(FreezingRecipe.class, (RecipeType)AetherRecipeTypes.FREEZING.get(), recipe -> AetherCookingRecipeDisplay.of(AetherREIServerPlugin.FREEZING, recipe));
        registry.registerRecipeFiller(IncubationRecipe.class, (RecipeType)AetherRecipeTypes.INCUBATION.get(), recipe -> AetherCookingRecipeDisplay.of(AetherREIServerPlugin.INCUBATING, recipe));
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new BlockBanRecipeCategory());
        registry.add((DisplayCategory)new ItemBanRecipeCategory());
        registry.add(AetherBlockStateRecipeCategory.accessoryFreezable());
        registry.add(AetherBlockStateRecipeCategory.ambrosium());
        registry.add(AetherBlockStateRecipeCategory.icestoneFreezable());
        registry.add(BiomeParameterRecipeCategory.placementConversion());
        registry.add(BiomeParameterRecipeCategory.swetBall());
        registry.add((DisplayCategory)new AbstractFuelCategory(AetherREIServerPlugin.AETHER_FUEL, ALTAR_TEXTURE){

            public Component getTitle() {
                return Component.m_237115_((String)"gui.aether.jei.fuel");
            }
        });
        registry.add(AetherCookingRecipeCategory.altarRepair());
        registry.add(AetherCookingRecipeCategory.altarEnchanting());
        registry.add(AetherCookingRecipeCategory.freezing());
        registry.add(AetherCookingRecipeCategory.incubating());
        registry.addWorkstations(AetherREIServerPlugin.AETHER_FUEL, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.FREEZER.get())), EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.ALTAR.get())), EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.INCUBATOR.get()))});
        registry.addWorkstations(AetherREIServerPlugin.FREEZING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.FREEZER.get()))});
        registry.addWorkstations(AetherREIServerPlugin.ALTAR_REPAIR, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.ALTAR.get()))});
        registry.addWorkstations(AetherREIServerPlugin.ALTAR_ENCHANTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.ALTAR.get()))});
        registry.addWorkstations(AetherREIServerPlugin.INCUBATING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.INCUBATOR.get()))});
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register((TransferHandler)SimpleTransferHandler.create(AltarMenu.class, AetherREIServerPlugin.ALTAR_ENCHANTING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
        registry.register((TransferHandler)SimpleTransferHandler.create(AltarMenu.class, AetherREIServerPlugin.ALTAR_REPAIR, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
        registry.register((TransferHandler)SimpleTransferHandler.create(FreezerMenu.class, AetherREIServerPlugin.FREEZING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
        registry.register((TransferHandler)SimpleTransferHandler.create(IncubatorMenu.class, AetherREIServerPlugin.INCUBATING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
    }
}

