/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.quark;

import com.aetherteam.aether.client.gui.screen.inventory.AccessoriesScreen;
import com.aetherteam.aether.integration.quark.AccessoriesBackpackMenu;
import com.aetherteam.aether.integration.quark.AccessoriesBackpackScreen;
import com.aetherteam.aether.inventory.menu.AccessoriesMenu;
import com.aetherteam.aether.mixin.mixins.common.accessor.EntityAccessor;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.QuarkBackpackPacket;
import com.aetherteam.nitrogen.network.PacketRelay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.violetmoon.quark.addons.oddities.client.screen.BackpackInventoryScreen;
import org.violetmoon.quark.addons.oddities.inventory.BackpackMenu;
import org.violetmoon.quark.addons.oddities.item.BackpackItem;
import org.violetmoon.quark.addons.oddities.module.BackpackModule;

public class QuarkCompat {

    @Mod.EventBusSubscriber(modid="aether", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientForge {
        private static ItemStack heldStack = null;
        private static boolean backpackRequested;

        public static void requestInventoryBackpack() {
            BackpackModule.requestBackpack();
        }

        public static void requestAccessoriesBackpack() {
            heldStack = Minecraft.m_91087_().f_91074_.f_36095_.m_142621_();
            PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new QuarkBackpackPacket(true));
        }

        @SubscribeEvent
        public static void clientSetup(TickEvent.ClientTickEvent event) {
            if (ModList.get().isLoaded("quark")) {
                Minecraft mc = Minecraft.m_91087_();
                if (ClientForge.isAccessoriesInventoryGUI(mc.f_91080_) && !backpackRequested && BackpackModule.isEntityWearingBackpack((Entity)mc.f_91074_) && !((EntityAccessor)mc.f_91074_).aether$isIsInsidePortal() && !mc.f_91074_.m_7500_()) {
                    ClientForge.requestAccessoriesBackpack();
                    mc.f_91074_.f_36095_.m_142503_(mc.f_91074_.m_6844_(EquipmentSlot.CHEST));
                    backpackRequested = true;
                } else if (mc.f_91080_ instanceof BackpackInventoryScreen) {
                    if (heldStack != null) {
                        mc.f_91074_.f_36095_.m_142503_(heldStack);
                        heldStack = null;
                    }
                    backpackRequested = false;
                }
            }
        }

        private static boolean isAccessoriesInventoryGUI(Screen gui) {
            return gui != null && gui.getClass() == AccessoriesScreen.class;
        }

        public static boolean isAccessoriesBackpackGUI(Screen gui) {
            return gui instanceof AccessoriesBackpackScreen;
        }

        public static boolean isAccessoriesBackpackClass(Screen gui) {
            return gui.getClass() == AccessoriesBackpackScreen.class;
        }
    }

    @Mod.EventBusSubscriber(modid="aether", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientMod {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            if (ModList.get().isLoaded("quark")) {
                event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)Common.ACCESSORIES_BACKPACK.get()), AccessoriesBackpackScreen::new));
            }
        }
    }

    public static class Common {
        public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"aether");
        public static final RegistryObject<MenuType<AccessoriesBackpackMenu>> ACCESSORIES_BACKPACK = Common.registerMenu("accessories_backpack", AccessoriesBackpackMenu::new);

        public static void init(IEventBus modEventBus) {
            MENU_TYPES.register(modEventBus);
        }

        private static <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> registerMenu(String name, MenuType.MenuSupplier<T> menu) {
            return MENU_TYPES.register(name, () -> new MenuType(menu, FeatureFlags.f_244377_));
        }

        public static void executeQuarkBackpackPacketBehavior(Player playerEntity, boolean open) {
            if (playerEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                if (open) {
                    ItemStack stack = playerEntity.m_6844_(EquipmentSlot.CHEST);
                    if (stack.m_41720_() instanceof BackpackItem && playerEntity.f_36096_ != null) {
                        ItemStack holding = playerEntity.f_36096_.m_142621_().m_41777_();
                        playerEntity.f_36096_.m_142503_(ItemStack.f_41583_);
                        Common.openAccessoriesBackpack(serverPlayer);
                        playerEntity.f_36096_.m_142503_(holding);
                    }
                } else if (playerEntity.f_36096_ != null) {
                    ItemStack holding = playerEntity.f_36096_.m_142621_();
                    playerEntity.f_36096_.m_142503_(ItemStack.f_41583_);
                    BackpackMenu.saveCraftingInventory((Player)playerEntity);
                    playerEntity.f_36096_ = playerEntity.f_36095_;
                    playerEntity.f_36095_.m_142503_(holding);
                }
            }
        }

        public static void openAccessoriesBackpack(ServerPlayer serverPlayer) {
            if (BackpackModule.isEntityWearingBackpack((Entity)serverPlayer)) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, inventory, playerEntity) -> new AccessoriesBackpackMenu(id, inventory), (Component)Component.m_237115_((String)"container.crafting")));
            } else {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, inventory, playerEntity) -> new AccessoriesMenu(id, inventory), (Component)Component.m_237115_((String)"container.crafting")));
            }
        }
    }
}

