/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.NotGrounded;
import com.aetherteam.aether.entity.WingedBird;
import com.aetherteam.aether.entity.ai.goal.FallingRandomStrollGoal;
import com.aetherteam.aether.entity.ai.navigator.FallPathNavigation;
import com.aetherteam.aether.entity.projectile.PoisonNeedle;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.common.ForgeMod;

public class Cockatrice
extends Monster
implements RangedAttackMob,
WingedBird,
NotGrounded {
    private static final EntityDataAccessor<Boolean> DATA_ENTITY_ON_GROUND_ID = SynchedEntityData.m_135353_(Cockatrice.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float wingRotation;
    private float prevWingRotation;
    private float destPos;
    private float prevDestPos;
    private int flapCooldown;

    public Cockatrice(EntityType<? extends Cockatrice> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new FallingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected PathNavigation m_6037_(Level level) {
        return new FallPathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_ENTITY_ON_GROUND_ID, (Object)true);
    }

    public static boolean checkCockatriceSpawnRules(EntityType<? extends Cockatrice> cockatrice, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Mob.m_217057_(cockatrice, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random) && Cockatrice.m_219009_(level, pos, random) && !level.m_8055_(pos.m_7495_()).m_204336_(AetherTags.Blocks.COCKATRICE_SPAWNABLE_BLACKLIST) && level.m_46791_() != Difficulty.PEACEFUL && (reason != MobSpawnType.NATURAL || random.m_188503_(3) == 0);
    }

    public static boolean m_219009_(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        if (level.m_45517_(LightLayer.SKY, pos) > random.m_188503_(32)) {
            return false;
        }
        DimensionType dimensiontype = level.m_6042_();
        int i = dimensiontype.m_223570_();
        if (i < 15 && level.m_45517_(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        return level.m_46803_(pos) <= dimensiontype.m_223569_().m_214085_(random);
    }

    public void m_8107_() {
        super.m_8107_();
        this.animateWings();
    }

    public void m_8119_() {
        AttributeInstance gravity;
        super.m_8119_();
        if (this.m_20096_()) {
            this.setEntityOnGround(true);
        }
        if ((gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get())) != null) {
            double fallSpeed = Math.max(gravity.m_22135_() * -1.25, -0.1);
            if (this.m_20184_().m_7098_() < fallSpeed) {
                this.m_20334_(this.m_20184_().m_7096_(), fallSpeed, this.m_20184_().m_7094_());
                this.f_19812_ = true;
                this.setEntityOnGround(false);
            }
        }
        if (this.getFlapCooldown() > 0) {
            this.setFlapCooldown(this.getFlapCooldown() - 1);
        } else if (this.getFlapCooldown() == 0 && !this.m_20096_()) {
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)AetherSoundEvents.ENTITY_COCKATRICE_FLAP.get(), SoundSource.NEUTRAL, 0.15f, Mth.m_14036_((float)this.m_217043_().m_188501_(), (float)0.7f, (float)1.0f) + Mth.m_14036_((float)this.m_217043_().m_188501_(), (float)0.0f, (float)0.3f));
            this.setFlapCooldown(15);
        }
    }

    protected void m_6135_() {
        super.m_6135_();
        this.setEntityOnGround(false);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        PoisonNeedle needle = new PoisonNeedle(this.m_9236_(), (LivingEntity)this);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.75) - needle.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(Mth.m_144952_((double)d0) + Mth.m_144952_((double)d2))));
        needle.m_6686_(d0, d1 + d3 * 0.2, d2, 1.0f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
        this.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_COCKATRICE_SHOOT.get(), 2.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)needle);
    }

    @Override
    public boolean isEntityOnGround() {
        return (Boolean)this.m_20088_().m_135370_(DATA_ENTITY_ON_GROUND_ID);
    }

    @Override
    public void setEntityOnGround(boolean onGround) {
        this.m_20088_().m_135381_(DATA_ENTITY_ON_GROUND_ID, (Object)onGround);
    }

    @Override
    public float getWingRotation() {
        return this.wingRotation;
    }

    @Override
    public void setWingRotation(float rotation) {
        this.wingRotation = rotation;
    }

    @Override
    public float getPrevWingRotation() {
        return this.prevWingRotation;
    }

    @Override
    public void setPrevWingRotation(float rotation) {
        this.prevWingRotation = rotation;
    }

    @Override
    public float getWingDestPos() {
        return this.destPos;
    }

    @Override
    public void setWingDestPos(float pos) {
        this.destPos = pos;
    }

    @Override
    public float getPrevWingDestPos() {
        return this.prevDestPos;
    }

    @Override
    public void setPrevWingDestPos(float pos) {
        this.prevDestPos = pos;
    }

    public int getFlapCooldown() {
        return this.flapCooldown;
    }

    public void setFlapCooldown(int flapCooldown) {
        this.flapCooldown = flapCooldown;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_COCKATRICE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_COCKATRICE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_COCKATRICE_DEATH.get();
    }

    public int m_6056_() {
        return this.m_20096_() ? super.m_6056_() : 14;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() != AetherEffects.INEBRIATION.get() && super.m_7301_(effect);
    }
}

