/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.providers;

import com.aetherteam.nitrogen.data.providers.NitrogenLanguageProvider;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;

public abstract class AetherLanguageProvider
extends NitrogenLanguageProvider {
    private final Map<String, String> PRO_TIPS = new HashMap<String, String>();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final PackOutput output;

    public AetherLanguageProvider(PackOutput output, String id) {
        super(output, id);
        this.output = output;
    }

    public void addMoaSkinsText(String key, String name) {
        this.addGuiText("moa_skins." + key, name);
    }

    public void addCustomizationText(String key, String name) {
        this.addGuiText("customization." + key, name);
    }

    public void addLoreBookText(String key, String name) {
        this.addGuiText("book_of_lore." + key, name);
    }

    public void addLore(Supplier<? extends ItemLike> key, String name) {
        this.add("lore." + key.get().m_5456_().m_5524_(), name);
    }

    public void addLoreUnique(String key, String name) {
        this.add("lore." + key, name);
    }

    public void addProTip(String key, String name) {
        String fullKey = "aether.pro_tips.line." + this.id + "." + key;
        this.add(fullKey, name);
        this.PRO_TIPS.put(fullKey, key);
    }

    public void addMenuTitle(String key, String name) {
        this.add(this.id + ".menu_title." + key, name);
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        CompletableFuture languageGen = super.m_213708_(cache);
        return languageGen;
    }

    private CompletableFuture<?> generateProTips(CompletableFuture<?> languageGen, CachedOutput cache) {
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        futuresBuilder.add(languageGen);
        for (Map.Entry<String, String> entry : this.PRO_TIPS.entrySet()) {
            JsonObject object = new JsonObject();
            object.add("title", Component.Serializer.m_130716_((Component)Component.m_237115_((String)"tipsmod.title.default").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE, ChatFormatting.YELLOW})));
            object.add("tip", Component.Serializer.m_130716_((Component)Component.m_237115_((String)entry.getKey())));
            futuresBuilder.add((Object)DataProvider.m_253162_((CachedOutput)cache, (JsonElement)GSON.toJsonTree((Object)object), (Path)this.output.m_245114_().resolve("packs/tips/assets/aether/tips/" + entry.getValue() + ".json")));
        }
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }
}

