/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.inventory;

import com.aetherteam.aether.client.gui.component.inventory.LorePageButton;
import com.aetherteam.aether.inventory.menu.LoreBookMenu;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class LoreBookScreen
extends AbstractContainerScreen<LoreBookMenu> {
    private static final ResourceLocation TEXTURE_LORE_BACKING = new ResourceLocation("aether", "textures/gui/menu/lore_backing.png");
    private static final ResourceLocation TEXTURE_LORE_BOOK = new ResourceLocation("aether", "textures/gui/menu/lore_book.png");
    private final Map<Integer, List<FormattedCharSequence>> pages = new HashMap<Integer, List<FormattedCharSequence>>();
    private LorePageButton previousButton;
    private LorePageButton nextButton;
    private int currentPageNumber;
    private ItemStack lastStack;

    public LoreBookScreen(LoreBookMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 256;
        this.f_97727_ = 199;
    }

    protected void m_7856_() {
        super.m_7856_();
        int xPos = (this.f_96543_ - this.getXSize()) / 2;
        int yPos = (this.f_96544_ - this.getYSize()) / 2;
        this.previousButton = (LorePageButton)this.m_142416_((GuiEventListener)new LorePageButton(new Button.Builder((Component)Component.m_237113_((String)"<"), button -> {
            if (this.currentPageNumber > 0) {
                --this.currentPageNumber;
            }
        }).m_252987_(xPos + 14, yPos + 169, 20, 20)));
        this.nextButton = (LorePageButton)this.m_142416_((GuiEventListener)new LorePageButton(new Button.Builder((Component)Component.m_237113_((String)">"), button -> {
            if (this.currentPageNumber < this.pages.size() - 1) {
                ++this.currentPageNumber;
            }
        }).m_252987_(xPos + 221, yPos + 169, 20, 20)));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int x, int y) {
        String entryKey;
        MutableComponent previous = Component.m_237115_((String)"gui.aether.book_of_lore.previous");
        MutableComponent next = Component.m_237115_((String)"gui.aether.book_of_lore.next");
        this.drawNormalBookText(guiGraphics, this.f_96547_, (Component)previous, 13, 158);
        this.drawNormalBookText(guiGraphics, this.f_96547_, (Component)next, 221, 158);
        MutableComponent book = Component.m_237115_((String)"gui.aether.book_of_lore.book");
        MutableComponent ofLore = Component.m_237115_((String)"gui.aether.book_of_lore.of_lore");
        this.drawCenteredBookText(guiGraphics, this.f_96547_, (Component)book, 75, 20);
        this.drawCenteredBookText(guiGraphics, this.f_96547_, (Component)ofLore, 75, 30);
        MutableComponent item = Component.m_237115_((String)"gui.aether.book_of_lore.item");
        this.drawRightBookText(guiGraphics, this.f_96547_, (Component)item, 78, 67);
        ItemStack itemStack = ((Slot)((LoreBookMenu)this.m_6262_()).f_38839_.get(0)).m_7993_();
        if (!itemStack.m_41619_() && I18n.m_118936_((String)(entryKey = ((LoreBookMenu)this.m_6262_()).getLoreEntryKey(itemStack)))) {
            MutableComponent entry = Component.m_237115_((String)entryKey);
            this.createPages((Component)entry);
            if (this.currentPageNumber == 0) {
                MutableComponent title = itemStack.m_41786_().m_6879_();
                this.createText(guiGraphics, this.f_96547_.m_92923_((FormattedText)title, 98), 136, 10);
                this.createText(guiGraphics, this.pages.get(0), 136, 32);
            } else {
                this.createText(guiGraphics, this.pages.get(this.currentPageNumber), 136, 10);
            }
        }
        if (itemStack.m_41619_() || !itemStack.m_150930_(this.lastStack.m_41720_())) {
            this.pages.clear();
            this.currentPageNumber = 0;
        }
        this.previousButton.f_93623_ = this.currentPageNumber > 0;
        this.nextButton.f_93623_ = this.currentPageNumber < this.pages.size() - 1;
        this.lastStack = itemStack;
    }

    private void createPages(Component loreEntry) {
        ArrayList formattedText = new ArrayList(this.f_96547_.m_92923_((FormattedText)loreEntry, 98));
        if (formattedText.size() < 6) {
            List firstPage = formattedText.subList(0, formattedText.size());
            this.pages.put(0, firstPage);
        } else {
            List firstPage = formattedText.subList(0, 6);
            this.pages.put(0, firstPage);
            List remainingPages = formattedText.subList(6, formattedText.size());
            List list = Lists.partition(remainingPages, (int)8);
            for (int i = 1; i < list.size() + 1; ++i) {
                this.pages.put(i, (List)list.get(i - 1));
            }
        }
    }

    private void createText(GuiGraphics guiGraphics, List<FormattedCharSequence> reorderingProcessors, int x, int y) {
        int length = 0;
        for (FormattedCharSequence line : reorderingProcessors) {
            this.drawBookText(guiGraphics, this.f_96547_, line, x, y + length * 10);
            ++length;
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        int xPos = (this.f_96543_ - this.getXSize()) / 2;
        int yPos = (this.f_96544_ - this.getYSize()) / 2;
        guiGraphics.m_280163_(TEXTURE_LORE_BACKING, xPos, yPos - 4, 0.0f, 0.0f, this.getXSize(), this.getYSize() + 56, 256, 256);
        guiGraphics.m_280163_(TEXTURE_LORE_BOOK, xPos + 12, yPos + 2, 0.0f, 0.0f, this.getXSize(), this.getYSize() + 56, 256, 256);
    }

    private void drawNormalBookText(GuiGraphics guiGraphics, Font fontRenderer, Component component, int x, int y) {
        FormattedCharSequence sequence = component.m_7532_();
        this.drawBookText(guiGraphics, fontRenderer, sequence, x, y);
    }

    private void drawRightBookText(GuiGraphics guiGraphics, Font fontRenderer, Component component, int x, int y) {
        FormattedCharSequence sequence = component.m_7532_();
        this.drawBookText(guiGraphics, fontRenderer, sequence, x - fontRenderer.m_92724_(sequence), y);
    }

    private void drawCenteredBookText(GuiGraphics guiGraphics, Font fontRenderer, Component component, int x, int y) {
        FormattedCharSequence sequence = component.m_7532_();
        this.drawBookText(guiGraphics, fontRenderer, sequence, x - fontRenderer.m_92724_(sequence) / 2, y);
    }

    private void drawBookText(GuiGraphics guiGraphics, Font fontRenderer, FormattedCharSequence sequence, int x, int y) {
        guiGraphics.m_280649_(fontRenderer, sequence, x, y, 0x404040, false);
    }
}

