/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.event;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;

@Mod.EventBusSubscriber(modid="farmersdelight")
public class MappingEvents {
    public static ResourceLocation mapping(String name) {
        return new ResourceLocation("farmersdelight", name);
    }

    @SubscribeEvent
    public static void blockRemapping(MissingMappingsEvent event) {
        List mappings = event.getMappings(ForgeRegistries.Keys.BLOCKS, "farmersdelight");
        ImmutableMap blockRemapping = new ImmutableMap.Builder().put((Object)MappingEvents.mapping("oak_pantry"), ModBlocks.OAK_CABINET).put((Object)MappingEvents.mapping("birch_pantry"), ModBlocks.BIRCH_CABINET).put((Object)MappingEvents.mapping("spruce_pantry"), ModBlocks.SPRUCE_CABINET).put((Object)MappingEvents.mapping("jungle_pantry"), ModBlocks.JUNGLE_CABINET).put((Object)MappingEvents.mapping("acacia_pantry"), ModBlocks.ACACIA_CABINET).put((Object)MappingEvents.mapping("dark_oak_pantry"), ModBlocks.DARK_OAK_CABINET).put((Object)MappingEvents.mapping("crimson_pantry"), ModBlocks.CRIMSON_CABINET).put((Object)MappingEvents.mapping("warped_pantry"), ModBlocks.WARPED_CABINET).put((Object)MappingEvents.mapping("rice_crop"), ModBlocks.RICE_CROP).put((Object)MappingEvents.mapping("rice_upper_crop"), ModBlocks.RICE_CROP_PANICLES).build();
        for (MissingMappingsEvent.Mapping mapping : mappings) {
            Block block;
            Supplier blockSupplier = (Supplier)blockRemapping.get(mapping.getKey());
            if (blockSupplier == null || ForgeRegistries.BLOCKS.getKey((Object)(block = (Block)blockSupplier.get())) == null) continue;
            mapping.remap((Object)block);
            FarmersDelight.LOGGER.warn("Remapping block '{}' to '{}'...", (Object)mapping.getKey().toString(), (Object)ForgeRegistries.BLOCKS.getKey((Object)block).toString());
        }
    }

    @SubscribeEvent
    public static void itemRemapping(MissingMappingsEvent event) {
        List mappings = event.getMappings(ForgeRegistries.Keys.ITEMS, "farmersdelight");
        ImmutableMap itemRemapping = new ImmutableMap.Builder().put((Object)MappingEvents.mapping("oak_pantry"), ModItems.OAK_CABINET).put((Object)MappingEvents.mapping("birch_pantry"), ModItems.BIRCH_CABINET).put((Object)MappingEvents.mapping("spruce_pantry"), ModItems.SPRUCE_CABINET).put((Object)MappingEvents.mapping("jungle_pantry"), ModItems.JUNGLE_CABINET).put((Object)MappingEvents.mapping("acacia_pantry"), ModItems.ACACIA_CABINET).put((Object)MappingEvents.mapping("dark_oak_pantry"), ModItems.DARK_OAK_CABINET).put((Object)MappingEvents.mapping("crimson_pantry"), ModItems.CRIMSON_CABINET).put((Object)MappingEvents.mapping("warped_pantry"), ModItems.WARPED_CABINET).build();
        for (MissingMappingsEvent.Mapping mapping : mappings) {
            Item item;
            Supplier itemSupplier = (Supplier)itemRemapping.get(mapping.getKey());
            if (itemSupplier == null || (item = (Item)itemSupplier.get()) == null || ForgeRegistries.ITEMS.getKey((Object)item) == null) continue;
            mapping.remap((Object)item);
            FarmersDelight.LOGGER.warn("Remapping item '{}' to '{}'...", (Object)mapping.getKey().toString(), (Object)ForgeRegistries.ITEMS.getKey((Object)item).toString());
        }
    }
}

