/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.furniture.refurbished.util.ItemHash;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class Utils {
    public static ResourceLocation resource(String name) {
        return new ResourceLocation("refurbished_furniture", name);
    }

    public static MutableComponent translation(String category, String path, Object ... params) {
        return Component.m_237110_((String)String.format("%s.%s.%s", category, "refurbished_furniture", path), (Object[])params);
    }

    public static String translationKey(String category, String path) {
        return String.format("%s.%s.%s", category, "refurbished_furniture", path);
    }

    public static <T> void shuffle(List<T> list, RandomSource random) {
        for (int i = list.size() - 1; i > 0; --i) {
            int randIndex = random.m_216332_(0, i);
            T temp = list.get(i);
            list.set(i, list.get(randIndex));
            list.set(randIndex, temp);
        }
    }

    public static <T> List<T> concat(Collection<T> a, Collection<T> b) {
        return Stream.concat(a.stream(), b.stream()).collect(Collectors.toList());
    }

    public static double pixels(double value) {
        return value * 0.0625;
    }

    public static Map<Item, Integer> countItems(boolean skipDamaged, List<Pair<Direction, Container>> containers) {
        Object2IntOpenCustomHashMap map = new Object2IntOpenCustomHashMap((Hash.Strategy)ItemHash.INSTANCE);
        for (Pair<Direction, Container> pair : containers) {
            Direction direction = (Direction)pair.first();
            Container container = (Container)pair.second();
            Utils.getContainerSlots(container, direction).forEach(arg_0 -> Utils.lambda$countItems$0(container, skipDamaged, direction, (Map)map, arg_0));
        }
        return map;
    }

    public static int countItem(Item item, Container container) {
        return IntStream.range(0, container.m_6643_()).mapToObj(arg_0 -> ((Container)container).m_8020_(arg_0)).filter(stack -> stack.m_150930_(item)).map(ItemStack::m_41613_).reduce(Integer::sum).orElse(0);
    }

    public static IntStream getContainerSlots(Container container, @Nullable Direction direction) {
        if (direction != null && container instanceof WorldlyContainer) {
            WorldlyContainer worldly = (WorldlyContainer)container;
            return IntStream.of(worldly.m_7071_(direction));
        }
        return IntStream.range(0, container.m_6643_());
    }

    public static boolean canTakeFromContainer(Container container, int slot, ItemStack stack, @Nullable Direction direction) {
        if (container.m_271862_(container, slot, stack)) {
            if (direction != null && container instanceof WorldlyContainer) {
                WorldlyContainer worldly = (WorldlyContainer)container;
                return worldly.m_7157_(slot, stack, direction);
            }
            return true;
        }
        return false;
    }

    public static Ingredient getIngredient(JsonObject object, String key) {
        if (GsonHelper.m_13885_((JsonObject)object, (String)key)) {
            return Ingredient.m_288218_((JsonElement)GsonHelper.m_13933_((JsonObject)object, (String)key), (boolean)false);
        }
        return Ingredient.m_288218_((JsonElement)GsonHelper.m_13930_((JsonObject)object, (String)key), (boolean)false);
    }

    public static ItemStack getItemStack(JsonObject object, String key) {
        if (GsonHelper.m_13813_((JsonObject)object, (String)key)) {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)key));
            Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(id).orElseThrow(() -> new IllegalStateException("The item '%s' does not exist".formatted(id)));
            return new ItemStack((ItemLike)item);
        }
        if (GsonHelper.m_144772_((JsonObject)object, (String)key)) {
            JsonObject itemObject = GsonHelper.m_13930_((JsonObject)object, (String)key);
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)itemObject, (String)"item"));
            Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(id).orElseThrow(() -> new IllegalStateException("The item '%s' does not exist".formatted(id)));
            int count = GsonHelper.m_13824_((JsonObject)itemObject, (String)"count", (int)1);
            return new ItemStack((ItemLike)item, count);
        }
        throw new IllegalStateException("'%s' must be either a string or object".formatted(key));
    }

    public static Fluid getFluid(JsonObject object, String key) {
        ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)key));
        return (Fluid)BuiltInRegistries.f_257020_.m_6612_(id).orElseThrow(() -> new RuntimeException("The fluid '%s' does not exist".formatted(id)));
    }

    private static /* synthetic */ void lambda$countItems$0(Container container, boolean skipDamaged, Direction direction, Map map, int slot) {
        ItemStack stack = container.m_8020_(slot);
        if (stack.m_41619_() || skipDamaged && stack.m_41768_()) {
            return;
        }
        if (!Utils.canTakeFromContainer(container, slot, stack, direction)) {
            return;
        }
        map.merge(stack.m_41720_(), stack.m_41613_(), Integer::sum);
    }
}

