/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.block.FreezerBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleProcessingLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.IContainerHolder;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FreezerBlockEntity
extends ElectricityModuleProcessingLootBlockEntity
implements IPowerSwitch,
IHomeControlDevice,
StackedContentsCompatible {
    public static final int[] INPUT_SLOTS = new int[]{0};
    public static final int[] OUTPUT_SLOTS = new int[]{1};
    public static final int DATA_POWERED = 0;
    public static final int DATA_ENABLED = 1;
    public static final int DATA_PROCESS_TIME = 2;
    public static final int DATA_MAX_PROCESS_TIME = 3;
    protected boolean enabled;
    protected final ContainerData data = new BuildableContainerData(builder -> {
        builder.add(0, () -> this.powered ? 1 : 0, value -> {});
        builder.add(1, () -> this.enabled ? 1 : 0, value -> {});
        builder.add(2, () -> this.processingTime, value -> {
            this.processingTime = value;
        });
        builder.add(3, () -> this.totalProcessingTime, value -> {
            this.totalProcessingTime = value;
        });
    });

    public FreezerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.FREEZER.get(), pos, state, 2, (RecipeType<? extends ProcessingRecipe>)((RecipeType)ModRecipeTypes.FREEZER_SOLIDIFYING.get()));
    }

    public FreezerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 2, (RecipeType<? extends ProcessingRecipe>)((RecipeType)ModRecipeTypes.FREEZER_SOLIDIFYING.get()));
    }

    protected Component m_6820_() {
        return Utils.translation("container", "freezer", new Object[0]);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return Services.MENU.createFreezerMenu(windowId, playerInventory, (Container)this, this.data);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        IContainerHolder holder;
        return menu instanceof IContainerHolder && (holder = (IContainerHolder)menu).container() == this;
    }

    @Override
    public int[] m_7071_(Direction direction) {
        return direction == Direction.DOWN ? OUTPUT_SLOTS : INPUT_SLOTS;
    }

    @Override
    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    @Override
    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }

    @Override
    public int[] getEnergySlots() {
        return NO_SLOTS;
    }

    @Override
    public boolean m_271862_(Container container, int slotIndex, ItemStack stack) {
        return slotIndex != 0 || !this.isRecipe(stack);
    }

    @Override
    public boolean canProcess() {
        return super.canProcess() && this.enabled;
    }

    @Override
    public void onOpen(Level level, BlockPos pos, BlockState state) {
        Vec3 door = Vec3.m_82512_((Vec3i)this.f_58858_).m_231075_(((Direction)state.m_61143_((Property)FreezerBlock.DIRECTION)).m_122424_(), 0.5);
        level.m_6263_(null, door.f_82479_, door.f_82480_, door.f_82481_, (SoundEvent)ModSounds.BLOCK_FREEZER_OPEN.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.f_46441_.m_188501_());
        this.setDoorState(state, true);
    }

    @Override
    public void onClose(Level level, BlockPos pos, BlockState state) {
        Vec3 door = Vec3.m_82512_((Vec3i)this.f_58858_).m_231075_(((Direction)state.m_61143_((Property)FreezerBlock.DIRECTION)).m_122424_(), 0.5);
        level.m_6263_(null, door.f_82479_, door.f_82480_, door.f_82481_, (SoundEvent)ModSounds.BLOCK_FREEZER_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.f_46441_.m_188501_());
        this.setDoorState(state, false);
    }

    private void setDoorState(BlockState state, boolean open) {
        Level level = this.m_58904_();
        if (level != null) {
            level.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)FreezerBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    @Override
    public void togglePower() {
        this.enabled = !this.enabled;
        this.m_6596_();
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this.m_5995_());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("Enabled", 1)) {
            this.enabled = tag.m_128471_("Enabled");
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Enabled", this.enabled);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("Enabled", this.enabled);
        return tag;
    }

    @Override
    public BlockPos getDevicePos() {
        return this.f_58858_;
    }

    @Override
    public boolean isDeviceEnabled() {
        return this.enabled;
    }

    @Override
    public void toggleDeviceState() {
        this.enabled = !this.enabled;
        this.m_6596_();
        this.syncDataToTrackingClients();
    }

    @Override
    public void setDeviceState(boolean enabled) {
        this.enabled = enabled;
        this.m_6596_();
        this.syncDataToTrackingClients();
    }

    @Override
    public Component getDeviceName() {
        if (this.m_8077_()) {
            return this.m_7770_();
        }
        return this.m_6820_();
    }

    public void m_5809_(StackedContents contents) {
        for (ItemStack stack : this.items) {
            contents.m_36491_(stack);
        }
    }
}

