/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen.noise;

import java.util.function.LongFunction;
import net.minecraft.core.RegistryAccess;
import terrablender.api.RegionType;
import terrablender.core.TerraBlender;
import terrablender.worldgen.noise.Area;
import terrablender.worldgen.noise.AreaContext;
import terrablender.worldgen.noise.AreaFactory;
import terrablender.worldgen.noise.AreaTransformer1;
import terrablender.worldgen.noise.InitialLayer;
import terrablender.worldgen.noise.ZoomLayer;

public class LayeredNoiseUtil {
    public static Area uniqueness(RegistryAccess registryAccess, RegionType regionType, long worldSeed) {
        int numZooms = TerraBlender.CONFIG.overworldRegionSize;
        if (regionType == RegionType.NETHER) {
            numZooms = TerraBlender.CONFIG.netherRegionSize;
        }
        LongFunction<AreaContext> contextFactory = seedModifier -> new AreaContext(25, worldSeed, seedModifier);
        AreaFactory factory = new InitialLayer(registryAccess, regionType).run(contextFactory.apply(1L));
        factory = ZoomLayer.FUZZY.run(contextFactory.apply(2000L), factory);
        factory = LayeredNoiseUtil.zoom(2001L, ZoomLayer.NORMAL, factory, 3, contextFactory);
        factory = LayeredNoiseUtil.zoom(1001L, ZoomLayer.NORMAL, factory, numZooms, contextFactory);
        return factory.make();
    }

    public static AreaFactory zoom(long seedModifier, AreaTransformer1 transformer, AreaFactory initialAreaFactory, int times, LongFunction<AreaContext> contextFactory) {
        AreaFactory areaFactory = initialAreaFactory;
        for (int i = 0; i < times; ++i) {
            areaFactory = transformer.run(contextFactory.apply(seedModifier + (long)i), areaFactory);
        }
        return areaFactory;
    }
}

