/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.util.VoxelOutliner;
import org.joml.Matrix4f;

public class BlockHighlightRenderHelper {
    public static void renderThickEdges(PoseStack poseStack, MultiBufferSource bufferSource, int color, List<VoxelOutliner.Edge> edges, BlockPos originPos) {
        BlockHighlightRenderHelper.renderThickEdges(poseStack, bufferSource, color, edges, originPos.m_123341_(), originPos.m_123342_(), originPos.m_123343_());
    }

    public static void renderThickEdges(PoseStack poseStack, MultiBufferSource bufferSource, int color, List<VoxelOutliner.Edge> edges, double originX, double originY, double originZ) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(QuadRenderType.OUTLINE_QUADS);
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        edges.forEach(edge -> BlockHighlightRenderHelper.emitThickLineOrtho(vertexConsumer, pose, edge.a(), edge.b(), 0.03125f, red, green, blue, 255, originX, originY, originZ));
    }

    public static void emitThickLineOrtho(VertexConsumer vc, Matrix4f pose, Vec3 a, Vec3 b, float thickness, int r, int g, int bl, int alpha, double originX, double originY, double originZ) {
        Vec3 w;
        Vec3 v;
        float rh = thickness * 0.5f;
        Vec3 d = b.m_82546_(a);
        Vec3 u = new Vec3(Math.signum(d.f_82479_), Math.signum(d.f_82480_), Math.signum(d.f_82481_));
        Vec3 aEx = a.m_82546_(u.m_82490_((double)rh));
        Vec3 bEx = b.m_82549_(u.m_82490_((double)rh));
        if (u.f_82479_ != 0.0) {
            v = new Vec3(0.0, 1.0, 0.0);
            w = new Vec3(0.0, 0.0, 1.0);
        } else if (u.f_82480_ != 0.0) {
            v = new Vec3(1.0, 0.0, 0.0);
            w = new Vec3(0.0, 0.0, 1.0);
        } else {
            v = new Vec3(1.0, 0.0, 0.0);
            w = new Vec3(0.0, 1.0, 0.0);
        }
        Vec3 vOff = v.m_82490_((double)rh);
        Vec3 wOff = w.m_82490_((double)rh);
        Vec3 aVpWm = aEx.m_82549_(vOff).m_82546_(wOff);
        Vec3 aVpWp = aEx.m_82549_(vOff).m_82549_(wOff);
        Vec3 aVmWp = aEx.m_82546_(vOff).m_82549_(wOff);
        Vec3 aVmWm = aEx.m_82546_(vOff).m_82546_(wOff);
        Vec3 bVpWm = bEx.m_82549_(vOff).m_82546_(wOff);
        Vec3 bVpWp = bEx.m_82549_(vOff).m_82549_(wOff);
        Vec3 bVmWp = bEx.m_82546_(vOff).m_82549_(wOff);
        Vec3 bVmWm = bEx.m_82546_(vOff).m_82546_(wOff);
        BlockHighlightRenderHelper.emitQuad(vc, pose, aVpWm, aVpWp, bVpWp, bVpWm, r, g, bl, alpha, originX, originY, originZ);
        BlockHighlightRenderHelper.emitQuad(vc, pose, aVmWp, aVmWm, bVmWm, bVmWp, r, g, bl, alpha, originX, originY, originZ);
        BlockHighlightRenderHelper.emitQuad(vc, pose, aVmWp, aVpWp, bVpWp, bVmWp, r, g, bl, alpha, originX, originY, originZ);
        BlockHighlightRenderHelper.emitQuad(vc, pose, aVpWm, aVmWm, bVmWm, bVpWm, r, g, bl, alpha, originX, originY, originZ);
    }

    private static void emitQuad(VertexConsumer vc, Matrix4f pose, Vec3 p0, Vec3 p1, Vec3 p2, Vec3 p3, int r, int g, int b, int a, double originX, double originY, double originZ) {
        BlockHighlightRenderHelper.add(vc, pose, p0, r, g, b, a, originX, originY, originZ);
        BlockHighlightRenderHelper.add(vc, pose, p1, r, g, b, a, originX, originY, originZ);
        BlockHighlightRenderHelper.add(vc, pose, p2, r, g, b, a, originX, originY, originZ);
        BlockHighlightRenderHelper.add(vc, pose, p3, r, g, b, a, originX, originY, originZ);
    }

    private static void add(VertexConsumer vc, Matrix4f pose, Vec3 p, int r, int g, int b, int a, double originX, double originY, double originZ) {
        vc.m_252986_(pose, (float)(p.f_82479_ - originX), (float)(p.f_82480_ - originY), (float)(p.f_82481_ - originZ)).m_6122_(r, g, b, a).m_5752_();
    }

    private static class QuadRenderType
    extends RenderType {
        private static final RenderType OUTLINE_QUADS = RenderType.m_173215_((String)"storage_outline_quads", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173104_).m_110663_(RenderStateShard.f_110113_).m_110661_(RenderStateShard.f_110110_).m_110685_(RenderStateShard.f_110134_).m_110687_(RenderStateShard.f_110114_).m_110669_(RenderStateShard.f_110119_).m_110675_(RenderStateShard.f_110123_).m_110691_(true));

        public QuadRenderType(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
            super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
        }
    }
}

