/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.controls;

import it.unimi.dsi.fastutil.floats.FloatConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ColorButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.CompositeWidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.TextBox;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;

public class ColorPicker
extends CompositeWidgetBase<WidgetBase> {
    public static final int COLOR_GRADIENT_WIDTH = 50;
    public static final int RAINBOW_SLIDER_WIDTH = 10;
    public static final int COLOR_ENTRY_WIDTH = 62;
    public static final int COLOR_GRADIENT_HEIGHT = 50;
    public static final Dimension DIMENSIONS = new Dimension(114, 84);
    private final TextBox textColorEntry;
    private final ColorPreview colorPreview;
    private final ColorGradientArea colorGradientArea;
    private final RainbowSlider rainbowSlider;
    private final Button confirmButton;
    private final Button cancelButton;
    private final Button transparentColorButton;
    private final List<ColorButton> defaultColorButtons = new ArrayList<ColorButton>();

    public ColorPicker(final Screen screen, Position position, int color, IntConsumer colorSetter) {
        super(position, DIMENSIONS);
        this.colorPreview = new ColorPreview(new Position(0, 0), new Dimension(50, 12), color);
        this.addChild(this.colorPreview);
        this.textColorEntry = new TextBox(new Position(0, 0), new Dimension(62, 12)){

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.isEditable()) {
                    this.m_93692_(true);
                    screen.m_7522_((GuiEventListener)ColorPicker.this.textColorEntry);
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
        };
        this.addChild(this.textColorEntry);
        this.colorGradientArea = new ColorGradientArea(new Position(0, 0), new Dimension(50, 50), gradientColor -> {
            this.textColorEntry.setValueWithoutNotification(ColorHelper.getHexColor(gradientColor));
            this.colorPreview.setColor(gradientColor);
        });
        this.colorGradientArea.setColor(color);
        this.rainbowSlider = new RainbowSlider(new Position(0, 0), new Dimension(10, 50), this.colorGradientArea::setHue);
        this.rainbowSlider.setColor(color);
        this.addChild(this.rainbowSlider);
        this.addChild(this.colorGradientArea);
        this.textColorEntry.setValue(ColorHelper.getHexColor(color));
        this.textColorEntry.setResponder(s -> {
            if (s.length() != 7) {
                return;
            }
            try {
                int c = ColorHelper.opaque(Integer.parseInt(s.substring(1), 16));
                this.colorPreview.setColor(c);
                this.colorGradientArea.setColor(c);
                this.rainbowSlider.setColor(c);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.addChild(this.textColorEntry);
        this.confirmButton = new Button(new Position(0, 0), ButtonDefinitions.CONFIRM, button -> colorSetter.accept(this.colorPreview.getColor()));
        this.addChild(this.confirmButton);
        this.transparentColorButton = new Button(new Position(0, 0), ButtonDefinitions.TRANSPARENT, button -> colorSetter.accept(-1));
        this.addChild(this.transparentColorButton);
        this.cancelButton = new Button(new Position(0, 0), ButtonDefinitions.CANCEL, button -> colorSetter.accept(color));
        this.addChild(this.cancelButton);
        this.addDefaultColorButtons();
        this.setPosition(position);
    }

    private void addDefaultColorButtons() {
        for (DyeColor value : DyeColor.values()) {
            int color = ColorHelper.opaque(ColorHelper.getColor(value.m_41068_()));
            ColorButton colorButton = new ColorButton(new Position(0, 0), new Dimension(11, 11), () -> color, button -> {
                this.colorGradientArea.setColor(color);
                this.rainbowSlider.setColor(color);
                this.colorPreview.setColor(color);
                this.textColorEntry.setValueWithoutNotification(ColorHelper.getHexColor(color));
            }, null);
            this.defaultColorButtons.add(colorButton);
            this.addChild(colorButton);
        }
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
        GuiHelper.renderControlBackground(guiGraphics, this.x - 5, this.y - 5, this.getWidth() + 5 + 5, this.getHeight() + 5 + 5, 128, 0, 128, 256);
    }

    @Override
    public void setPosition(Position position) {
        super.setPosition(position);
        this.textColorEntry.setPosition(new Position(this.x, this.y + this.colorGradientArea.getHeight() + 2));
        this.colorPreview.setPosition(new Position(this.x + this.textColorEntry.getWidth() + 2, this.y + this.colorGradientArea.getHeight() + 2));
        this.colorGradientArea.setPosition(new Position(this.x, this.y));
        this.rainbowSlider.setPosition(new Position(this.x + this.colorGradientArea.getWidth() + 2, this.y));
        this.confirmButton.setPosition(new Position(this.x + this.getWidth() / 2 - 32, this.y + this.colorGradientArea.getHeight() + 2 + this.textColorEntry.getHeight() + 2));
        this.transparentColorButton.setPosition(new Position(this.x + this.getWidth() / 2 - 8, this.confirmButton.getY()));
        this.cancelButton.setPosition(new Position(this.x + this.getWidth() / 2 + 16, this.confirmButton.getY()));
        int row = 0;
        int column = 0;
        for (ColorButton defaultColorButton : this.defaultColorButtons) {
            defaultColorButton.setPosition(new Position(this.rainbowSlider.getX() + this.rainbowSlider.getWidth() + 2 + column * 13, this.y + row * 13));
            if (++column <= 3) continue;
            column = 0;
            ++row;
        }
    }

    private static int opaque(int p_330851_) {
        return p_330851_ | 0xFF000000;
    }

    private static class ColorPreview
    extends WidgetBase {
        private int color;

        protected ColorPreview(Position position, Dimension dimension, int color) {
            super(position, dimension);
            this.color = color;
        }

        public void setColor(int color) {
            this.color = color;
        }

        @Override
        protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
        }

        @Override
        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            guiGraphics.m_280509_(this.x, this.y, this.x + this.getWidth(), this.y + this.getHeight(), this.color);
        }

        public int getColor() {
            return this.color;
        }
    }

    private static class ColorGradientArea
    extends WidgetBase {
        private int color;
        private float hue;
        private final IntConsumer colorSetter;

        protected ColorGradientArea(Position position, Dimension dimension, IntConsumer colorSetter) {
            super(position, dimension);
            this.colorSetter = colorSetter;
        }

        public void setColor(int color) {
            this.color = color;
            this.hue = Color.RGBtoHSB(FastColor.ARGB32.m_13665_((int)color), FastColor.ARGB32.m_13667_((int)color), FastColor.ARGB32.m_13669_((int)color), null)[0];
        }

        public void setHue(float hue) {
            this.hue = hue;
            float[] hsv = Color.RGBtoHSB(FastColor.ARGB32.m_13665_((int)this.color), FastColor.ARGB32.m_13667_((int)this.color), FastColor.ARGB32.m_13669_((int)this.color), null);
            float saturation = hsv[1];
            float value = hsv[2];
            this.color = ColorHelper.opaque(Mth.m_14169_((float)hue, (float)saturation, (float)value));
            this.colorSetter.accept(this.color);
        }

        @Override
        protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
            int topRightCornerColor = Mth.m_14169_((float)this.hue, (float)1.0f, (float)1.0f);
            int red = FastColor.ARGB32.m_13665_((int)topRightCornerColor);
            int green = FastColor.ARGB32.m_13667_((int)topRightCornerColor);
            int blue = FastColor.ARGB32.m_13669_((int)topRightCornerColor);
            for (int i = 0; i < this.getWidth(); ++i) {
                for (int j = 0; j < this.getHeight(); ++j) {
                    float horizontalFactor = (float)i / (float)this.getWidth();
                    float verticalFactor = (float)j / (float)this.getHeight();
                    int color = FastColor.ARGB32.m_13660_((int)255, (int)((int)((1.0f - verticalFactor) * ((1.0f - horizontalFactor) * 255.0f + (float)red * horizontalFactor))), (int)((int)((1.0f - verticalFactor) * ((1.0f - horizontalFactor) * 255.0f + (float)green * horizontalFactor))), (int)((int)((1.0f - verticalFactor) * ((1.0f - horizontalFactor) * 255.0f + (float)blue * horizontalFactor))));
                    guiGraphics.m_280509_(this.x + i, this.y + j, this.x + i + 1, this.y + j + 1, color);
                }
            }
        }

        @Override
        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            float[] hsv = Color.RGBtoHSB(FastColor.ARGB32.m_13665_((int)this.color), FastColor.ARGB32.m_13667_((int)this.color), FastColor.ARGB32.m_13669_((int)this.color), null);
            int x = (int)(hsv[1] * (float)this.getWidth());
            int y = (int)((1.0f - hsv[2]) * (float)this.getHeight());
            GuiHelper.fill(guiGraphics, this.x, (float)this.y + Math.max((float)y - 0.2f, 0.0f), this.x + this.getWidth(), (float)this.y + Math.min((float)y + 1.2f, (float)this.getHeight()), -1);
            GuiHelper.fill(guiGraphics, (float)this.x + Math.max((float)x - 0.2f, 0.0f), this.y, (float)this.x + Math.min((float)x + 1.2f, (float)this.getWidth()), this.y + this.getHeight(), -1);
            GuiHelper.fill(guiGraphics, this.x, this.y + y, this.x + this.getWidth(), this.y + y + 1, -16777216);
            GuiHelper.fill(guiGraphics, this.x + x, this.y, this.x + x + 1, this.y + this.getHeight(), -16777216);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.setColorBasedOnMouseCoords(mouseX, mouseY);
            return true;
        }

        private void setColorBasedOnMouseCoords(double mouseX, double mouseY) {
            double xClicked = mouseX - (double)this.x;
            double yClicked = mouseY - (double)this.y;
            float saturation = (float)xClicked / (float)this.getWidth();
            float value = 1.0f - (float)yClicked / (float)this.getHeight();
            this.color = ColorHelper.opaque(Mth.m_14169_((float)this.hue, (float)saturation, (float)value));
            this.colorSetter.accept(this.color);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            this.setColorBasedOnMouseCoords(mouseX, mouseY);
            return true;
        }
    }

    private static class RainbowSlider
    extends WidgetBase {
        private final FloatConsumer hueSetter;
        private float hue;

        protected RainbowSlider(Position position, Dimension dimension, FloatConsumer hueSetter) {
            super(position, dimension);
            this.hueSetter = hueSetter;
        }

        public void setColor(int color) {
            float[] hsl = Color.RGBtoHSB(FastColor.ARGB32.m_13665_((int)color), FastColor.ARGB32.m_13667_((int)color), FastColor.ARGB32.m_13669_((int)color), null);
            this.hue = hsl[0];
        }

        @Override
        protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
            for (int i = 0; i < this.getHeight(); ++i) {
                float renderedHue = (float)i / (float)this.getHeight();
                int color = ColorHelper.opaque(Mth.m_14169_((float)renderedHue, (float)1.0f, (float)1.0f));
                guiGraphics.m_280509_(this.x, this.y + this.getHeight() - i, this.x + this.getWidth(), this.y + this.getHeight() - i - 1, color);
            }
        }

        @Override
        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            int hueMarker = (int)(this.hue * (float)this.getHeight());
            GuiHelper.fill(guiGraphics, this.x, this.y + this.getHeight() - hueMarker - 1, this.x + this.getWidth(), (float)(this.y + this.getHeight() - hueMarker) - 1.2f, -1);
            GuiHelper.fill(guiGraphics, this.x, this.y + this.getHeight() - hueMarker, this.x + this.getWidth(), this.y + this.getHeight() - hueMarker - 1, -16777216);
            GuiHelper.fill(guiGraphics, this.x, this.y + this.getHeight() - hueMarker, this.x + this.getWidth(), (float)(this.y + this.getHeight() - hueMarker) + 0.2f, -1);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.setHueBasedOnMouseY(mouseY);
            return true;
        }

        private void setHueBasedOnMouseY(double mouseY) {
            double yClicked = mouseY - (double)this.y;
            this.hue = 1.0f - (float)yClicked / (float)this.getHeight();
            this.hueSetter.accept(this.hue);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            this.setHueBasedOnMouseY(mouseY);
            return true;
        }
    }
}

