/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.blocks;

import com.google.common.collect.ImmutableList;
import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.corelib.block.DirectionalVoxelShape;
import de.maxhenkel.gravestone.corelib.block.IItemBlock;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.entity.GhostPlayerEntity;
import de.maxhenkel.gravestone.items.ObituaryItem;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GraveStoneBlock
extends Block
implements EntityBlock,
IItemBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape BASE1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape BASE2 = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final DirectionalVoxelShape SHAPE = new DirectionalVoxelShape.Builder().direction(Direction.NORTH, BASE1, BASE2, Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)12.0, (double)2.0), Block.m_49796_((double)2.0, (double)12.0, (double)1.0, (double)14.0, (double)14.0, (double)2.0), Block.m_49796_((double)3.0, (double)14.0, (double)1.0, (double)13.0, (double)15.0, (double)2.0)).direction(Direction.SOUTH, BASE1, BASE2, Block.m_49796_((double)1.0, (double)2.0, (double)14.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)2.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0, (double)15.0), Block.m_49796_((double)3.0, (double)14.0, (double)14.0, (double)13.0, (double)15.0, (double)15.0)).direction(Direction.EAST, BASE1, BASE2, Block.m_49796_((double)14.0, (double)2.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)14.0, (double)12.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0), Block.m_49796_((double)14.0, (double)14.0, (double)3.0, (double)15.0, (double)15.0, (double)13.0)).direction(Direction.WEST, BASE1, BASE2, Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)2.0, (double)12.0, (double)15.0), Block.m_49796_((double)1.0, (double)12.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), Block.m_49796_((double)1.0, (double)14.0, (double)3.0, (double)2.0, (double)15.0, (double)13.0)).build();

    public GraveStoneBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60913_(0.3f, Float.MAX_VALUE));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Item toItem() {
        return new BlockItem((Block)this, new Item.Properties());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.m_41788_() && (tileentity = world.m_7702_(pos)) instanceof GraveStoneTileEntity) {
            GraveStoneTileEntity grave = (GraveStoneTileEntity)tileentity;
            grave.setCustomName(stack.m_41786_());
        }
        super.m_6402_(world, pos, state, placer, stack);
    }

    public void m_7592_(Level world, BlockPos pos, Explosion explosion) {
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (!(tileentity instanceof GraveStoneTileEntity)) {
            return InteractionResult.FAIL;
        }
        GraveStoneTileEntity grave = (GraveStoneTileEntity)tileentity;
        Component name = grave.getGraveName();
        if (name == null) {
            return InteractionResult.FAIL;
        }
        if (world.f_46443_) {
            MutableComponent time = GraveUtils.getDate(grave.getDeath().getTimestamp());
            if (time == null) {
                player.m_213846_(name);
            } else {
                player.m_213846_((Component)Component.m_237110_((String)"message.gravestone.died", (Object[])new Object[]{name, time}));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity = world.m_7702_(pos);
            if (tileentity instanceof GraveStoneTileEntity) {
                this.dropItems(world, pos, ((GraveStoneTileEntity)tileentity).getDeath().getAllItems());
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public void dropItems(Level world, BlockPos pos, NonNullList<ItemStack> items) {
        for (ItemStack item : items) {
            Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)item);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!GraveUtils.canBreakGrave(world, player, pos)) {
            return false;
        }
        BlockEntity te = world.m_7702_(pos);
        if (!world.f_46443_ && te instanceof GraveStoneTileEntity) {
            GraveStoneTileEntity grave = (GraveStoneTileEntity)te;
            this.removeObituary(player, grave);
            this.spawnGhost(world, pos, grave);
            if (!grave.getDeath().getId().equals(GraveUtils.EMPTY_UUID) && ((Boolean)Main.SERVER_CONFIG.breakPickup.get()).booleanValue()) {
                this.sortItems(world, pos, player, grave);
            }
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    protected void spawnGhost(Level world, BlockPos pos, GraveStoneTileEntity grave) {
        if (!((Boolean)Main.SERVER_CONFIG.spawnGhost.get()).booleanValue()) {
            return;
        }
        if (!world.m_46859_(pos.m_7494_())) {
            return;
        }
        UUID uuid = grave.getDeath().getPlayerUUID();
        if (uuid.equals(GraveUtils.EMPTY_UUID)) {
            return;
        }
        GhostPlayerEntity ghost = new GhostPlayerEntity(world, uuid, (Component)Component.m_237113_((String)grave.getDeath().getPlayerName()), grave.getDeath().getEquipment(), grave.getDeath().getModel());
        ghost.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5);
        world.m_7967_((Entity)ghost);
    }

    protected void removeObituary(Player p, GraveStoneTileEntity grave) {
        if (!((Boolean)Main.SERVER_CONFIG.removeObituary.get()).booleanValue()) {
            return;
        }
        if (!(p instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)p;
        Inventory inv = player.m_150109_();
        ImmutableList invs = ImmutableList.of((Object)player.m_150109_().f_35974_, (Object)player.m_150109_().f_35975_, (Object)player.m_150109_().f_35976_);
        for (NonNullList i : invs) {
            for (ItemStack stack : i) {
                Death death;
                if (!stack.m_41720_().equals(Main.OBITUARY.get()) || (death = ((ObituaryItem)((Object)Main.OBITUARY.get())).fromStack(player, stack)) == null || grave.getDeath().getId().equals(GraveUtils.EMPTY_UUID) || !grave.getDeath().getId().equals(death.getId())) continue;
                inv.m_36057_(stack);
            }
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(state, world, pos, entity);
        if (!(entity instanceof ServerPlayer && entity.m_6084_() && ((Boolean)Main.SERVER_CONFIG.sneakPickup.get()).booleanValue())) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!player.m_6144_() || player.m_150110_().f_35937_ || !GraveUtils.canBreakGrave(world, (Player)player, pos)) {
            return;
        }
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof GraveStoneTileEntity)) {
            return;
        }
        GraveStoneTileEntity grave = (GraveStoneTileEntity)te;
        if (grave.getDeath().getId().equals(GraveUtils.EMPTY_UUID)) {
            return;
        }
        this.removeObituary((Player)player, grave);
        this.spawnGhost(world, pos, grave);
        this.sortItems(world, pos, (Player)player, grave);
        world.m_46961_(pos, true);
    }

    protected void sortItems(Level world, BlockPos pos, Player player, GraveStoneTileEntity grave) {
        Death death = grave.getDeath();
        this.dropItems(world, pos, this.fillPlayerInventory(player, death));
        world.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
        grave.m_6596_();
    }

    public NonNullList<ItemStack> fillPlayerInventory(Player player, Death death) {
        NonNullList additionalItems = NonNullList.m_122779_();
        this.fillInventory((List<ItemStack>)additionalItems, death.getMainInventory(), (NonNullList<ItemStack>)player.m_150109_().f_35974_);
        this.fillInventory((List<ItemStack>)additionalItems, death.getArmorInventory(), (NonNullList<ItemStack>)player.m_150109_().f_35975_);
        this.fillInventory((List<ItemStack>)additionalItems, death.getOffHandInventory(), (NonNullList<ItemStack>)player.m_150109_().f_35976_);
        additionalItems.addAll(death.getAdditionalItems());
        NonNullList restItems = NonNullList.m_122779_();
        for (ItemStack stack : additionalItems) {
            if (player.m_150109_().m_36054_(stack)) continue;
            restItems.add((Object)stack);
        }
        death.getAdditionalItems().clear();
        return restItems;
    }

    public void fillInventory(List<ItemStack> additionalItems, NonNullList<ItemStack> inventory, NonNullList<ItemStack> playerInv) {
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.m_41619_()) continue;
            ItemStack playerStack = (ItemStack)playerInv.get(i);
            if (!playerStack.m_41619_()) {
                additionalItems.add(playerStack);
            }
            inventory.set(i, (Object)ItemStack.f_41583_);
            playerInv.set(i, (Object)stack);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return SHAPE.get((Direction)state.m_61143_((Property)FACING));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GraveStoneTileEntity(pos, state);
    }
}

