/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.schematic;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.schematic.ParsedSchematicObject;
import com.natamus.collective_common_forge.schematic.Schematic;
import com.natamus.collective_common_forge.schematic.SchematicBlockObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ParseSchematicFile {
    public static ParsedSchematicObject getParsedSchematicObject(InputStream schematicInputStream, Level level, BlockPos centerPos, int extraYOffset, boolean skipAir) {
        return ParseSchematicFile.getParsedSchematicObject(schematicInputStream, level, centerPos, extraYOffset, skipAir, true);
    }

    @Nullable
    public static ParsedSchematicObject getParsedSchematicObject(InputStream schematicInputStream, Level level, BlockPos centerPos, int extraYOffset, boolean skipAir, boolean automaticCenter) {
        Schematic schematic = new Schematic(schematicInputStream, level);
        if (!schematic.wasParsedCorrectly()) {
            return null;
        }
        int maxBuildHeight = level.m_151558_();
        short length = schematic.getLength();
        short width = schematic.getWidth();
        short height = schematic.getHeight();
        int xoffset = schematic.getOffsetX();
        int yoffset = centerPos.m_123342_() + extraYOffset;
        int zoffset = schematic.getOffsetZ();
        if (automaticCenter) {
            xoffset = -(width / 2);
            if (yoffset + height > maxBuildHeight) {
                yoffset = maxBuildHeight - height;
            }
            zoffset = -(length / 2);
        } else {
            yoffset += schematic.getOffsetY();
        }
        ArrayList<Pair<BlockPos, BlockState>> blocks = new ArrayList<Pair<BlockPos, BlockState>>();
        for (SchematicBlockObject blockObject : schematic.getBlocks()) {
            if (blockObject == null) continue;
            BlockState blockState = blockObject.getState();
            if (skipAir && blockState.m_60734_().equals(Blocks.f_50016_)) continue;
            blocks.add(new Pair((Object)blockObject.getPosition().m_7918_(centerPos.m_123341_() + xoffset, yoffset, centerPos.m_123343_() + zoffset).m_7949_(), (Object)blockState));
        }
        ArrayList<Pair<BlockPos, Entity>> entities = new ArrayList<Pair<BlockPos, Entity>>();
        for (Pair<BlockPos, CompoundTag> rawEntityPair : schematic.getEntityRelativePosPairs()) {
            Optional optionalNewEntity = EntityType.m_20642_((CompoundTag)((CompoundTag)rawEntityPair.getSecond()), (Level)level);
            if (!optionalNewEntity.isPresent()) continue;
            BlockPos actualEntityPosition = ((BlockPos)rawEntityPair.getFirst()).m_7918_(centerPos.m_123341_() + xoffset, yoffset, centerPos.m_123343_() + zoffset).m_7949_();
            Entity newEntity = (Entity)optionalNewEntity.get();
            newEntity.m_6034_((double)actualEntityPosition.m_123341_() + 0.5, (double)actualEntityPosition.m_123342_(), (double)actualEntityPosition.m_123343_() + 0.5);
            entities.add((Pair<BlockPos, Entity>)new Pair((Object)actualEntityPosition, (Object)newEntity));
        }
        ArrayList<BlockPos> blockEntityPositions = new ArrayList<BlockPos>();
        for (CompoundTag blockEntityCompoundTag : schematic.getBlockEntities()) {
            blockEntityPositions.add(schematic.getBlockPosFromCompoundTag(blockEntityCompoundTag).m_7918_(centerPos.m_123341_() + xoffset, yoffset, centerPos.m_123343_() + zoffset));
        }
        return new ParsedSchematicObject(schematic, blocks, entities, blockEntityPositions, "Parsed successfully.", true);
    }
}

