/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import jeresources.config.Settings;
import jeresources.jei.dungeon.DungeonCategory;
import jeresources.jei.dungeon.DungeonWrapper;
import jeresources.jei.enchantment.EnchantmentCategory;
import jeresources.jei.enchantment.EnchantmentMaker;
import jeresources.jei.enchantment.EnchantmentWrapper;
import jeresources.jei.mob.MobCategory;
import jeresources.jei.mob.MobWrapper;
import jeresources.jei.plant.PlantCategory;
import jeresources.jei.plant.PlantWrapper;
import jeresources.jei.villager.VillagerCategory;
import jeresources.jei.villager.VillagerWrapper;
import jeresources.jei.worldgen.WorldGenCategory;
import jeresources.jei.worldgen.WorldGenWrapper;
import jeresources.platform.Services;
import jeresources.registry.DungeonRegistry;
import jeresources.registry.MobRegistry;
import jeresources.registry.PlantRegistry;
import jeresources.registry.VillagerRegistry;
import jeresources.registry.WorldGenRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIConfig
implements IModPlugin {
    public static final ResourceLocation MOB = new ResourceLocation("jeresources", "mob");
    public static final RecipeType<MobWrapper> MOB_TYPE = new RecipeType(MOB, MobWrapper.class);
    public static final ResourceLocation DUNGEON = new ResourceLocation("jeresources", "dungeon");
    public static final RecipeType<DungeonWrapper> DUNGEON_TYPE = new RecipeType(DUNGEON, DungeonWrapper.class);
    public static final ResourceLocation WORLD_GEN = new ResourceLocation("jeresources", "worldgen");
    public static final RecipeType<WorldGenWrapper> WORLD_GEN_TYPE = new RecipeType(WORLD_GEN, WorldGenWrapper.class);
    public static final ResourceLocation PLANT = new ResourceLocation("jeresources", "plant");
    public static final RecipeType<PlantWrapper> PLANT_TYPE = new RecipeType(PLANT, PlantWrapper.class);
    public static final ResourceLocation ENCHANTMENT = new ResourceLocation("jeresources", "enchantment");
    public static final RecipeType<EnchantmentWrapper> ENCHANTMENT_TYPE = new RecipeType(ENCHANTMENT, EnchantmentWrapper.class);
    public static final ResourceLocation VILLAGER = new ResourceLocation("jeresources", "villager");
    public static final RecipeType<VillagerWrapper> VILLAGER_TYPE = new RecipeType(VILLAGER, VillagerWrapper.class);
    public static final Map<ResourceLocation, RecipeType<?>> TYPES = new HashMap();
    private static IJeiHelpers jeiHelpers;
    private static IJeiRuntime jeiRuntime;

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jeresources");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(DUNGEON_TYPE, JEIConfig.asRecipes(DungeonRegistry.getInstance().getDungeons(), DungeonWrapper::new));
        registration.addRecipes(ENCHANTMENT_TYPE, EnchantmentMaker.createRecipes(registration.getIngredientManager().getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)));
        registration.addRecipes(MOB_TYPE, JEIConfig.asRecipes(MobRegistry.getInstance().getMobs(), MobWrapper::new));
        registration.addRecipes(PLANT_TYPE, JEIConfig.asRecipes(PlantRegistry.getInstance().getAllPlants(), PlantWrapper::new));
        registration.addRecipes(VILLAGER_TYPE, JEIConfig.asRecipes(VillagerRegistry.getInstance().getVillagers(), VillagerWrapper::new));
        registration.addRecipes(WORLD_GEN_TYPE, JEIConfig.asRecipes(WorldGenRegistry.getInstance().getWorldGen(), WorldGenWrapper::new));
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        JEIConfig.jeiRuntime = jeiRuntime;
        JEIConfig.hideCategories(Settings.hiddenCategories);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        jeiHelpers = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new DungeonCategory(), new EnchantmentCategory(), new MobCategory(), new PlantCategory(), new VillagerCategory(), new WorldGenCategory()});
        Services.PLATFORM.getProxy().initCompatibility();
    }

    public static void resetCategories() {
        if (jeiRuntime != null) {
            for (RecipeType<?> recipeType : TYPES.values()) {
                jeiRuntime.getRecipeManager().unhideRecipeCategory(recipeType);
            }
        }
    }

    public static void hideCategories(String[] categories) {
        if (jeiRuntime != null) {
            for (String category : categories) {
                jeiRuntime.getRecipeManager().hideRecipeCategory(TYPES.get(new ResourceLocation("jeresources", category)));
            }
        }
    }

    public static IJeiHelpers getJeiHelpers() {
        return jeiHelpers;
    }

    private static <T, R> List<R> asRecipes(Collection<T> collection, Function<T, R> transformer) {
        return collection.stream().map(transformer).collect(Collectors.toList());
    }

    static {
        TYPES.put(MOB, MOB_TYPE);
        TYPES.put(DUNGEON, DUNGEON_TYPE);
        TYPES.put(WORLD_GEN, WORLD_GEN_TYPE);
        TYPES.put(PLANT, PLANT_TYPE);
        TYPES.put(ENCHANTMENT, ENCHANTMENT_TYPE);
        TYPES.put(VILLAGER, VILLAGER_TYPE);
    }
}

