/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.api.modifier.ParameterizedCache;
import com.tacz.guns.api.modifier.ParameterizedCachePair;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunRecoil;
import com.tacz.guns.resource.pojo.data.gun.GunRecoilKeyFrame;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RecoilModifier
implements IAttachmentModifier<Pair<Modifier, Modifier>, ParameterizedCachePair<Float, Float>> {
    public static final String ID = GunProperties.RECOIL.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getOptionalFields() {
        return "recoil_modifier";
    }

    @Override
    public JsonProperty<Pair<Modifier, Modifier>> readJson(String json) {
        Data data = (Data)CommonAssetsManager.GSON.fromJson(json, Data.class);
        NewRecoilData newRecoilData = data.newRecoilData;
        OldRecoilData oldRecoilData = data.oldRecoilData;
        if (newRecoilData == null && oldRecoilData != null) {
            Modifier pitch = new Modifier();
            Modifier yaw = new Modifier();
            pitch.setPercent(oldRecoilData.getPitch());
            yaw.setPercent(oldRecoilData.getYaw());
            return new RecoilJsonProperty((Pair<Modifier, Modifier>)Pair.of((Object)pitch, (Object)yaw));
        }
        assert (newRecoilData != null);
        return new RecoilJsonProperty((Pair<Modifier, Modifier>)Pair.of((Object)newRecoilData.getPitch(), (Object)newRecoilData.getYaw()));
    }

    @Override
    public CacheValue<ParameterizedCachePair<Float, Float>> initCache(ItemStack gunItem, GunData gunData) {
        GunRecoil recoil = gunData.getRecoil();
        if (recoil == null) {
            return new CacheValue<ParameterizedCachePair<Float, Float>>(ParameterizedCachePair.of(Float.valueOf(0.0f), Float.valueOf(0.0f)));
        }
        float pitch = RecoilModifier.getMaxInGunRecoilKeyFrame(recoil.getPitch());
        float yaw = RecoilModifier.getMaxInGunRecoilKeyFrame(recoil.getYaw());
        return new CacheValue<ParameterizedCachePair<Float, Float>>(ParameterizedCachePair.of(Float.valueOf(pitch), Float.valueOf(yaw)));
    }

    @Override
    public void eval(List<Pair<Modifier, Modifier>> modifiedValues, CacheValue<ParameterizedCachePair<Float, Float>> cache) {
        ArrayList yaw = Lists.newArrayList();
        ArrayList pitch = Lists.newArrayList();
        for (Pair<Modifier, Modifier> modifiedValue : modifiedValues) {
            pitch.add((Modifier)modifiedValue.left());
            yaw.add((Modifier)modifiedValue.right());
        }
        ParameterizedCachePair<Float, Float> newCache = ParameterizedCachePair.of(pitch, yaw, (Float)((ParameterizedCache)cache.getValue().left()).getDefaultValue(), (Float)((ParameterizedCache)cache.getValue().right()).getDefaultValue());
        cache.setValue(newCache);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IAttachmentModifier.DiagramsData> getPropertyDiagramsData(ItemStack gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        ParameterizedCachePair propertyCache = (ParameterizedCachePair)cacheProperty.getCache(ID);
        GunRecoil recoil = gunData.getRecoil();
        double pitch = ((Float)((ParameterizedCache)propertyCache.left()).getDefaultValue()).floatValue();
        double modifiedPitch = ((ParameterizedCache)propertyCache.left()).eval(RecoilModifier.getMaxInGunRecoilKeyFrame(recoil.getPitch()));
        double pitchModifier = modifiedPitch - pitch;
        double pitchPercent = Math.min(pitch / 5.0, 1.0);
        double pitchModifierPercent = Math.min(pitchModifier / 5.0, 1.0);
        String pitchTitleKey = "gui.tacz.gun_refit.property_diagrams.pitch";
        String pitchPositivelyString = String.format("%.2f \u00a7c(+%.2f)", modifiedPitch, pitchModifier);
        String pitchNegativelyString = String.format("%.2f \u00a7a(%.2f)", modifiedPitch, pitchModifier);
        String pitchDefaultString = String.format("%.2f", modifiedPitch);
        double yaw = ((Float)((ParameterizedCache)propertyCache.right()).getDefaultValue()).floatValue();
        double modifiedYaw = ((ParameterizedCache)propertyCache.right()).eval(RecoilModifier.getMaxInGunRecoilKeyFrame(recoil.getYaw()));
        double yawModifier = modifiedYaw - yaw;
        double yawPercent = Math.min(yaw / 5.0, 1.0);
        double yawModifierPercent = Math.min(yawModifier / 5.0, 1.0);
        String yawTitleKey = "gui.tacz.gun_refit.property_diagrams.yaw";
        String yawPositivelyString = String.format("%.2f \u00a7c(+%.2f)", modifiedYaw, yawModifier);
        String yawNegativelyString = String.format("%.2f \u00a7a(%.2f)", modifiedYaw, yawModifier);
        String yawDefaultString = String.format("%.2f", modifiedYaw);
        boolean positivelyBetter = false;
        IAttachmentModifier.DiagramsData pitchData = new IAttachmentModifier.DiagramsData(pitchPercent, pitchModifierPercent, pitchModifier, pitchTitleKey, pitchPositivelyString, pitchNegativelyString, pitchDefaultString, positivelyBetter);
        IAttachmentModifier.DiagramsData yawData = new IAttachmentModifier.DiagramsData(yawPercent, yawModifierPercent, yawModifier, yawTitleKey, yawPositivelyString, yawNegativelyString, yawDefaultString, positivelyBetter);
        return List.of(pitchData, yawData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getDiagramsDataSize() {
        return 2;
    }

    private static float getMaxInGunRecoilKeyFrame(GunRecoilKeyFrame[] frames) {
        if (frames.length == 0) {
            return 0.0f;
        }
        float[] value = frames[0].getValue();
        float leftValue = Math.abs(value[0]);
        float rightValue = Math.abs(value[1]);
        return Math.max(leftValue, rightValue);
    }

    public static class Data {
        @SerializedName(value="recoil_modifier")
        @Deprecated
        @Nullable
        private OldRecoilData oldRecoilData = null;
        @SerializedName(value="recoil")
        @Nullable
        private NewRecoilData newRecoilData = null;
    }

    private static class NewRecoilData {
        @SerializedName(value="pitch")
        private Modifier pitch = new Modifier();
        @SerializedName(value="yaw")
        private Modifier yaw = new Modifier();

        private NewRecoilData() {
        }

        public Modifier getPitch() {
            return this.pitch;
        }

        public Modifier getYaw() {
            return this.yaw;
        }
    }

    @Deprecated
    private static class OldRecoilData {
        @SerializedName(value="pitch")
        private float pitch = 0.0f;
        @SerializedName(value="yaw")
        private float yaw = 0.0f;

        private OldRecoilData() {
        }

        public float getPitch() {
            return this.pitch;
        }

        public float getYaw() {
            return this.yaw;
        }
    }

    public static class RecoilJsonProperty
    extends JsonProperty<Pair<Modifier, Modifier>> {
        public RecoilJsonProperty(Pair<Modifier, Modifier> value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Pair modified = (Pair)this.getValue();
            float pitch = 1.0f;
            float yaw = 1.0f;
            if (modified != null) {
                pitch = (float)AttachmentPropertyManager.eval((Modifier)modified.left(), 1.0);
                yaw = (float)AttachmentPropertyManager.eval((Modifier)modified.right(), 1.0);
            }
            if (pitch > 1.0f) {
                this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.pitch.increase").m_130940_(ChatFormatting.RED));
            } else if (pitch < 1.0f) {
                this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.pitch.decrease").m_130940_(ChatFormatting.GREEN));
            }
            if (yaw > 1.0f) {
                this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.yaw.increase").m_130940_(ChatFormatting.RED));
            } else if (yaw < 1.0f) {
                this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.yaw.decrease").m_130940_(ChatFormatting.GREEN));
            }
        }
    }
}

