/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message;

import com.tacz.guns.client.resource.ClientIndexManager;
import com.tacz.guns.resource.network.CommonNetworkCache;
import com.tacz.guns.resource.network.DataType;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ServerMessageSyncGunPack {
    private final Map<DataType, Map<ResourceLocation, String>> cache;

    public ServerMessageSyncGunPack(Map<DataType, Map<ResourceLocation, String>> cache) {
        this.cache = cache;
    }

    public static void encode(ServerMessageSyncGunPack message, FriendlyByteBuf buf) {
        buf.m_236831_(message.getCache(), FriendlyByteBuf::m_130068_, (buf1, map) -> buf1.m_236831_(map, FriendlyByteBuf::m_130085_, FriendlyByteBuf::m_130070_));
    }

    public static ServerMessageSyncGunPack decode(FriendlyByteBuf buf) {
        Map map = buf.m_236847_(buf1 -> (DataType)buf1.m_130066_(DataType.class), buf2 -> buf2.m_236847_(FriendlyByteBuf::m_130281_, FriendlyByteBuf::m_130277_));
        return new ServerMessageSyncGunPack(map);
    }

    public static void handle(ServerMessageSyncGunPack message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> ServerMessageSyncGunPack.doSync(message));
        }
        context.setPacketHandled(true);
    }

    public Map<DataType, Map<ResourceLocation, String>> getCache() {
        return this.cache;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void doSync(ServerMessageSyncGunPack message) {
        CommonNetworkCache.INSTANCE.fromNetwork(message.cache);
        ClientIndexManager.reload();
    }
}

