/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunHeatData;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class HeatBarOverlay
implements IGuiOverlay {
    private static final ResourceLocation HEATBASE = new ResourceLocation("tacz", "textures/hud/heat_base.png");
    private static final DecimalFormat HEAT_FORMAT_PERCENT = new DecimalFormat("0.0%");
    private static float heatScale = 0.25f;

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        if (!((Boolean)RenderConfig.GUN_HUD_ENABLE.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (!(player instanceof IClientPlayerGunOperator)) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(stack);
        GunData gunData = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getGunData).orElse(null);
        GunDisplayInstance display = TimelessAPI.getGunDisplay(stack).orElse(null);
        if (gunData == null || display == null) {
            return;
        }
        PoseStack poseStack = graphics.m_280168_();
        if (gunData.getHeatData() != null && iGun.hasHeatData(stack)) {
            poseStack.m_85836_();
            GunHeatData heatData = gunData.getHeatData();
            float percent = iGun.getHeatAmount(stack) / heatData.getHeatMax();
            float scaleValue = iGun.getHeatAmount(stack) / heatData.getHeatMax() / 8.0f + 0.75f;
            if (heatScale < scaleValue) {
                heatScale += 0.05f;
            }
            if (heatScale > scaleValue) {
                heatScale -= 0.025f;
            }
            if ((double)heatScale > (double)scaleValue - 0.03 && (double)heatScale < (double)scaleValue + 0.055) {
                heatScale = scaleValue;
            }
            poseStack.m_85841_(heatScale, heatScale, 1.0f);
            boolean locked = iGun.isOverheatLocked(stack);
            int tickCount = gui.m_93079_();
            this.renderOverheat(percent, graphics, (int)((float)width / heatScale), (int)((float)height / heatScale), locked, tickCount);
            poseStack.m_85849_();
        }
    }

    public void renderOverheat(float heatPercentage, GuiGraphics pGraphics, int w, int h, boolean locked, int tickCount) {
        String percentString;
        int barColor = HeatBarOverlay.getHeatColor(heatPercentage, locked, tickCount);
        pGraphics.m_280509_(w / 2 - 30, h / 2 + 30, w / 2 - 30 + (int)(heatPercentage * 60.0f), h / 2 + 34, barColor);
        if (locked) {
            if (tickCount % 20 < 10) {
                pGraphics.m_280246_(1.0f, 0.1f, 0.1f, 1.0f);
            } else {
                pGraphics.m_280246_(1.0f, 1.0f, 0.1f, 1.0f);
            }
        }
        pGraphics.m_280163_(HEATBASE, w / 2 - 64, h / 2 - 44, 0.0f, 0.0f, 128, 128, 128, 128);
        pGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        Font font = Minecraft.m_91087_().f_243022_;
        String string = percentString = locked ? "!OVERHEAT!" : HEAT_FORMAT_PERCENT.format(heatPercentage);
        int color = locked ? (tickCount % 20 < 10 ? -65536 : -256) : -1;
        pGraphics.m_280056_(font, percentString, w / 2 - font.m_92895_(percentString) / 2, h / 2 + 38, color, true);
    }

    public static int getHeatColor(float percent, boolean locked, int tickCount) {
        if (locked) {
            return tickCount % 20 < 10 ? -1610678272 : -1610612992;
        }
        if ((double)percent < 0.4) {
            return -1610612737;
        }
        int color = (double)percent <= 0.65 ? FastColor.ARGB32.m_269105_((float)(percent * 4.0f - 1.6f), (int)-1610612737, (int)-1610612992) : FastColor.ARGB32.m_269105_((float)((percent - 0.65f) / 0.35f), (int)-1610612992, (int)-1610678272);
        return color;
    }
}

