/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.api.event.common.EntityKillByGunEvent;
import com.tacz.guns.client.event.RenderCrosshairEvent;
import com.tacz.guns.client.gui.overlay.KillAmountOverlay;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.entity.TargetMinecart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientHitMark {
    public static long lastHitTimestamp = 0L;
    public static float damageAmount = 0.0f;

    @SubscribeEvent
    public static void onEntityHurt(EntityHurtByGunEvent.Post event) {
        LogicalSide logicalSide = event.getLogicalSide();
        if (logicalSide != LogicalSide.CLIENT) {
            return;
        }
        LivingEntity attacker = event.getAttacker();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Entity hurtEntity = event.getHurtEntity();
        if (player != null && player.equals((Object)attacker) && hurtEntity != null) {
            ResourceLocation gunId = event.getGunId();
            ResourceLocation gunDisplayId = event.getGunDisplayId();
            RenderCrosshairEvent.markHitTimestamp();
            if (event.isHeadShot()) {
                RenderCrosshairEvent.markHeadShotTimestamp();
                TimelessAPI.getGunDisplay(gunDisplayId, gunId).ifPresent(index -> SoundPlayManager.playHeadHitSound((LivingEntity)player, index));
            } else {
                TimelessAPI.getGunDisplay(gunDisplayId, gunId).ifPresent(index -> SoundPlayManager.playFleshHitSound((LivingEntity)player, index));
            }
            if (hurtEntity instanceof TargetMinecart) {
                damageAmount = System.currentTimeMillis() - lastHitTimestamp < (long)((Integer)RenderConfig.DAMAGE_COUNTER_RESET_TIME.get()).intValue() ? (damageAmount += event.getAmount()) : event.getAmount();
                float distance = player.m_20270_(event.getHurtEntity());
                player.m_5661_((Component)Component.m_237110_((String)"message.tacz.target_minecart.hit", (Object[])new Object[]{String.format("%.1f", Float.valueOf(damageAmount)), String.format("%.2f", Float.valueOf(distance))}), true);
                lastHitTimestamp = System.currentTimeMillis();
            }
        }
    }

    @SubscribeEvent
    public static void onEntityKill(EntityKillByGunEvent event) {
        LogicalSide logicalSide = event.getLogicalSide();
        if (logicalSide != LogicalSide.CLIENT) {
            return;
        }
        LivingEntity attacker = event.getAttacker();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.equals((Object)attacker)) {
            RenderCrosshairEvent.markKillTimestamp();
            KillAmountOverlay.markTimestamp();
            TimelessAPI.getGunDisplay(event.getGunDisplayId(), event.getGunId()).ifPresent(index -> SoundPlayManager.playKillSound((LivingEntity)player, index));
            if (event.isHeadShot()) {
                RenderCrosshairEvent.markHeadShotTimestamp();
            }
        }
    }
}

