/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.block;

import com.mojang.authlib.GameProfile;
import com.tacz.guns.block.entity.TargetBlockEntity;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TargetBlock
extends BaseEntityBlock {
    public static final IntegerProperty OUTPUT_POWER = BlockStateProperties.f_61426_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty STAND = BooleanProperty.m_61465_((String)"stand");
    public static final VoxelShape BOX_BOTTOM_STAND_X = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)Block.m_49796_((double)6.0, (double)13.0, (double)2.0, (double)10.0, (double)16.0, (double)14.0));
    public static final VoxelShape BOX_BOTTOM_STAND_Z = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)Block.m_49796_((double)2.0, (double)13.0, (double)6.0, (double)14.0, (double)16.0, (double)10.0));
    public static final VoxelShape BOX_BOTTOM_DOWN = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    public static final VoxelShape BOX_UPPER_X = Block.m_49796_((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)16.0, (double)14.0);
    public static final VoxelShape BOX_UPPER_Z = Block.m_49796_((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)16.0, (double)10.0);

    public TargetBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)STAND, (Comparable)Boolean.valueOf(true))).m_61124_((Property)OUTPUT_POWER, (Comparable)Integer.valueOf(0)));
    }

    public static int getRedstoneStrength(BlockHitResult hit, boolean isUpperBlock) {
        if (!isUpperBlock) {
            return 1;
        }
        Vec3 hitLocation = hit.m_82450_();
        Direction direction = hit.m_82434_();
        double x = Math.abs(Mth.m_14185_((double)hitLocation.f_82479_) - 0.5);
        double y = Math.abs(Mth.m_14185_((double)hitLocation.f_82480_) - 0.32);
        double z = Math.abs(Mth.m_14185_((double)hitLocation.f_82481_) - 0.5);
        Direction.Axis axis = direction.m_122434_();
        double distance = axis == Direction.Axis.Y ? Math.max(x, z) : (axis == Direction.Axis.Z ? Math.max(x, y) : Math.max(y, z));
        double percent = Mth.m_14008_((double)((0.25 - distance) / 0.25), (double)0.0, (double)1.0);
        return Math.max(1, Mth.m_14165_((double)(15.0 * percent)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return ((DoubleBlockHalf)state.m_61143_(HALF)).equals((Object)DoubleBlockHalf.LOWER) && level.m_5776_() ? TargetBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlocks.TARGET_BE.get()), TargetBlockEntity::clientTick) : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF, STAND, OUTPUT_POWER});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        if (((DoubleBlockHalf)blockState.m_61143_(HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
            return new TargetBlockEntity(pos, blockState);
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        boolean stand = (Boolean)state.m_61143_((Property)STAND);
        boolean axis = ((Direction)state.m_61143_((Property)FACING)).m_122434_().equals((Object)Direction.Axis.X);
        if (((DoubleBlockHalf)state.m_61143_(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            return stand ? (axis ? BOX_UPPER_X : BOX_UPPER_Z) : Shapes.m_83040_();
        }
        return stand ? (axis ? BOX_BOTTOM_STAND_X : BOX_BOTTOM_STAND_Z) : BOX_BOTTOM_DOWN;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)STAND)).booleanValue()) {
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)STAND, (Comparable)Boolean.valueOf(true))).m_61124_((Property)OUTPUT_POWER, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    public void m_5581_(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (hit.m_82434_().m_122424_().equals((Object)state.m_61143_((Property)FACING))) {
            Entity entity;
            if (((DoubleBlockHalf)state.m_61143_(HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
                world.m_141902_(hit.m_82425_(), TargetBlockEntity.TYPE).ifPresent(e -> e.hit(world, state, hit, false));
            } else if (((DoubleBlockHalf)state.m_61143_(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
                world.m_141902_(hit.m_82425_().m_7495_(), TargetBlockEntity.TYPE).ifPresent(e -> e.hit(world, state, hit, true));
            }
            if (!world.m_5776_() && (entity = projectile.m_19749_()) instanceof Player) {
                Player player = (Player)entity;
                if (((Boolean)state.m_61143_((Property)STAND)).booleanValue() && projectile instanceof EntityKineticBullet) {
                    EntityKineticBullet bullet = (EntityKineticBullet)projectile;
                    String formattedDamage = String.format("%.1f", Float.valueOf(bullet.getDamage(hit.m_82450_())));
                    String formattedDistance = String.format("%.2f", hit.m_82450_().m_82554_(player.m_20182_()));
                    player.m_5661_((Component)Component.m_237110_((String)"message.tacz.target_minecart.hit", (Object[])new Object[]{formattedDamage, formattedDistance}), true);
                }
            }
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        boolean stand = (Boolean)state.m_61143_((Property)STAND);
        if (facing.m_122434_() == Direction.Axis.Y && (half.equals((Object)DoubleBlockHalf.LOWER) && facing == Direction.UP || half.equals((Object)DoubleBlockHalf.UPPER) && facing == Direction.DOWN)) {
            if (!facingState.m_60713_((Block)this)) {
                return Blocks.f_50016_.m_49966_();
            }
            if ((Boolean)facingState.m_61143_((Property)STAND) != stand) {
                return (BlockState)((BlockState)state.m_61124_((Property)STAND, (Comparable)((Boolean)facingState.m_61143_((Property)STAND)))).m_61124_((Property)OUTPUT_POWER, (Comparable)((Integer)facingState.m_61143_((Property)OUTPUT_POWER)));
            }
        }
        if (half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos clickedPos = context.m_8083_();
        BlockPos above = clickedPos.m_7494_();
        Level level = context.m_43725_();
        if (level.m_8055_(above).m_60629_(context) && level.m_6857_().m_61937_(above)) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        if (!world.f_46443_) {
            BlockEntity blockentity;
            BlockPos above = pos.m_7494_();
            world.m_7731_(above, (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
            world.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)world, pos, 3);
            if (stack.m_41788_() && (blockentity = world.m_7702_(pos)) instanceof TargetBlockEntity) {
                TargetBlockEntity e = (TargetBlockEntity)blockentity;
                GameProfile gameprofile = new GameProfile(null, stack.m_41786_().getString());
                e.setOwner(gameprofile);
                e.setCustomName(stack.m_41786_());
                e.refresh();
            }
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockPos blockPos = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
        BlockEntity blockentity = level.m_7702_(blockPos);
        if (blockentity instanceof TargetBlockEntity) {
            TargetBlockEntity e = (TargetBlockEntity)blockentity;
            return new ItemStack((ItemLike)this).m_41714_(e.m_7770_());
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return true;
        }
        return blockstate.m_60713_((Block)this);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.m_61143_((Property)OUTPUT_POWER);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!(level.m_5776_() || state.m_60713_(oldState.m_60734_()) || (Integer)state.m_61143_((Property)OUTPUT_POWER) <= 0 || level.m_183326_().m_183582_(pos, (Object)this))) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)OUTPUT_POWER, (Comparable)Integer.valueOf(0)), 18);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }
}

