/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.platform;

import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.platform.services.IConfigHelper;
import com.mrcrayfish.framework.platform.services.IEntityHelper;
import com.mrcrayfish.framework.platform.services.IItemHelper;
import com.mrcrayfish.framework.platform.services.INetworkHelper;
import com.mrcrayfish.framework.platform.services.IPlatformHelper;
import com.mrcrayfish.framework.platform.services.IRegistrationHelper;
import java.util.ServiceLoader;

public class Services {
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    public static final INetworkHelper NETWORK = Services.load(INetworkHelper.class);
    public static final IRegistrationHelper REGISTRATION = Services.load(IRegistrationHelper.class);
    public static final IEntityHelper ENTITY = Services.load(IEntityHelper.class);
    public static final IItemHelper ITEM = Services.load(IItemHelper.class);
    public static final IConfigHelper CONFIG = Services.load(IConfigHelper.class);

    public static <T> T load(Class<T> serviceClass) {
        T loadedService = ServiceLoader.load(serviceClass).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + serviceClass.getName()));
        Constants.LOG.debug("Loaded {} for service {}", loadedService, serviceClass);
        return loadedService;
    }
}

