/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.projectile.MoonwormShot;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;

public class MoonwormQueenItem
extends Item {
    public static final int FIRING_TIME = 12;

    public MoonwormQueenItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41773_() + 1 >= this.getMaxDamage(stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack itemstack;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Player player = context.m_43723_();
        BlockPlaceContext blockItemUseContext = new BlockPlaceContext(context);
        if (!state.m_247087_()) {
            pos = pos.m_121945_(context.m_43719_());
        }
        if ((itemstack = player.m_21120_(context.m_43724_())).m_41773_() < itemstack.m_41776_() && player.m_36204_(pos, context.m_43719_(), itemstack) && level.m_45752_(((Block)TFBlocks.MOONWORM.get()).m_49966_(), pos, CollisionContext.m_82749_())) {
            if (this.tryPlace(blockItemUseContext).m_19080_()) {
                SoundType soundtype = level.m_8055_(pos).m_60734_().getSoundType(level.m_8055_(pos), (LevelReader)level, pos, (Entity)player);
                level.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                player.m_5810_();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int useRemaining) {
        int useTime = this.m_8105_(stack) - useRemaining;
        if (!level.m_5776_() && useTime > 12 && stack.m_41773_() + 1 < stack.m_41776_() && level.m_7967_((Entity)new MoonwormShot((EntityType<? extends MoonwormShot>)((EntityType)TFEntities.MOONWORM_SHOT.get()), level, living))) {
            if (living instanceof Player) {
                Player player = (Player)living;
                if (!player.m_150110_().f_35937_) {
                    stack.m_220157_(2, level.m_213780_(), null);
                }
            }
            level.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), (SoundEvent)TFSounds.MOONWORM_SQUISH.get(), living instanceof Player ? SoundSource.PLAYERS : SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResult tryPlace(BlockPlaceContext context) {
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockitemusecontext = this.getBlockItemUseContext(context);
        if (blockitemusecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getStateForPlacement(blockitemusecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockitemusecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.m_8083_();
        Level world = blockitemusecontext.m_43725_();
        Player playerentity = blockitemusecontext.m_43723_();
        ItemStack itemstack = blockitemusecontext.m_43722_();
        BlockState blockstate1 = world.m_8055_(blockpos);
        Block block = blockstate1.m_60734_();
        if (block == blockstate.m_60734_()) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, world, itemstack, blockstate1);
            this.onBlockPlaced(blockpos, world, playerentity, itemstack);
            block.m_6402_(world, blockpos, blockstate1, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)playerentity, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((LevelReader)world, blockpos, (Entity)context.m_43723_());
        world.m_5594_(playerentity, blockpos, this.getPlaceSound(blockstate1, world, blockpos, Objects.requireNonNull(context.m_43723_())), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (playerentity == null || !playerentity.m_150110_().f_35937_) {
            itemstack.m_220157_(1, world.f_46441_, null);
        }
        return InteractionResult.SUCCESS;
    }

    protected SoundEvent getPlaceSound(BlockState state, Level level, BlockPos pos, Player entity) {
        return state.getSoundType((LevelReader)level, pos, (Entity)entity).m_56777_();
    }

    @Nullable
    public BlockPlaceContext getBlockItemUseContext(BlockPlaceContext context) {
        return context;
    }

    protected boolean onBlockPlaced(BlockPos pos, Level level, @Nullable Player player, ItemStack stack) {
        return BlockItem.m_40582_((Level)level, (Player)player, (BlockPos)pos, (ItemStack)stack);
    }

    @Nullable
    protected BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = ((Block)TFBlocks.MOONWORM.get()).m_5573_(context);
        return blockstate != null && this.canPlace(context, blockstate) ? blockstate : null;
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.m_43723_();
        CollisionContext collision = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) && context.m_43725_().m_45752_(state, context.m_8083_(), collision);
    }

    private BlockState updateBlockStateFromTag(BlockPos pos, Level level, ItemStack stack, BlockState state) {
        BlockState blockstate = state;
        CompoundTag compoundnbt = stack.m_41783_();
        if (compoundnbt != null) {
            CompoundTag compoundnbt1 = compoundnbt.m_128469_("BlockStateTag");
            StateDefinition statecontainer = state.m_60734_().m_49965_();
            for (String s : compoundnbt1.m_128431_()) {
                Property property = statecontainer.m_61081_(s);
                if (property == null) continue;
                String s1 = compoundnbt1.m_128423_(s).m_7916_();
                blockstate = MoonwormQueenItem.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != state) {
            level.m_7731_(pos, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> property, String name) {
        return property.m_6215_(name).map(value -> (BlockState)state.m_61124_(property, value)).orElse(state);
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_7731_(context.m_8083_(), state, 11);
    }
}

