/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.TFConfig;
import twilightforest.block.TFPortalBlock;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.fan.FeatherFanFallCapability;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.capabilities.thrown.YetiThrowCapability;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateShieldPacket;

@Mod.EventBusSubscriber(modid="twilightforest")
public class CapabilityEvents {
    private static final String NBT_TAG_TWILIGHT = "twilightforest_banished";

    @SubscribeEvent
    public static void updateCaps(LivingEvent.LivingTickEvent event) {
        event.getEntity().getCapability(CapabilityList.SHIELDS).ifPresent(IShieldCapability::update);
        event.getEntity().getCapability(CapabilityList.FEATHER_FAN_FALLING).ifPresent(FeatherFanFallCapability::update);
        event.getEntity().getCapability(CapabilityList.YETI_THROWN).ifPresent(YetiThrowCapability::update);
    }

    @SubscribeEvent
    public static void livingAttack(LivingAttackEvent event) {
        LivingEntity living = event.getEntity();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_150110_().f_35934_) {
                return;
            }
        }
        if (!living.m_9236_().m_5776_() && !event.getSource().m_269533_(DamageTypeTags.f_268490_)) {
            living.getCapability(CapabilityList.SHIELDS).ifPresent(cap -> {
                if (cap.shieldsLeft() > 0) {
                    cap.breakShield();
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (event.isEndConquered()) {
            CapabilityEvents.updateCapabilities(serverPlayer, (Entity)serverPlayer);
        }
        if (((Boolean)TFConfig.COMMON_CONFIG.DIMENSION.newPlayersSpawnInTF.get()).booleanValue() && serverPlayer.m_8961_() == null) {
            CompoundTag tagCompound = serverPlayer.getPersistentData();
            CompoundTag playerData = tagCompound.m_128469_("PlayerPersisted");
            playerData.m_128379_(NBT_TAG_TWILIGHT, false);
            tagCompound.m_128365_("PlayerPersisted", (Tag)playerData);
            CapabilityEvents.banishNewbieToTwilightZone((Player)serverPlayer);
        }
    }

    @SubscribeEvent
    public static void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().m_9236_().m_5776_() && event.getEntity() instanceof ServerPlayer) {
            CapabilityEvents.updateCapabilities((ServerPlayer)event.getEntity(), (Entity)event.getEntity());
            CapabilityEvents.banishNewbieToTwilightZone(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerPortals(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player;
        if (!event.getEntity().m_9236_().m_5776_() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CapabilityEvents.updateCapabilities(player2, (Entity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        CapabilityEvents.updateCapabilities((ServerPlayer)event.getEntity(), event.getTarget());
    }

    private static void updateCapabilities(ServerPlayer clientTarget, Entity shielded) {
        shielded.getCapability(CapabilityList.SHIELDS).ifPresent(cap -> {
            if (cap.shieldsLeft() > 0) {
                TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> clientTarget), (Object)new UpdateShieldPacket(shielded, (IShieldCapability)cap));
            }
        });
    }

    private static void banishNewbieToTwilightZone(Player player) {
        CompoundTag tagCompound = player.getPersistentData();
        CompoundTag playerData = tagCompound.m_128469_("PlayerPersisted");
        boolean shouldBanishPlayer = (Boolean)TFConfig.COMMON_CONFIG.DIMENSION.newPlayersSpawnInTF.get() != false && !playerData.m_128471_(NBT_TAG_TWILIGHT);
        playerData.m_128379_(NBT_TAG_TWILIGHT, true);
        tagCompound.m_128365_("PlayerPersisted", (Tag)playerData);
        if (shouldBanishPlayer) {
            TFPortalBlock.attemptSendEntity((Entity)player, true, (Boolean)TFConfig.COMMON_CONFIG.DIMENSION.portalForNewPlayerSpawn.get());
        }
    }
}

