/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import twilightforest.TFConfig;
import twilightforest.init.TFSounds;

public interface IBossLootBuffer {
    public static final int CONTAINER_SIZE = 27;

    default public ItemStack getItem(int slot) {
        return (ItemStack)this.getItemStacks().get(slot);
    }

    default public void setItem(int slot, ItemStack stack) {
        this.getItemStacks().set(slot, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > 64) {
            stack.m_41764_(64);
        }
    }

    default public void addDeathItemsSaveData(CompoundTag tag) {
        ContainerHelper.m_18973_((CompoundTag)tag, this.getItemStacks());
    }

    default public void readDeathItemsSaveData(CompoundTag tag) {
        ContainerHelper.m_18980_((CompoundTag)tag, this.getItemStacks());
    }

    public static <T extends LivingEntity> void saveDropsIntoBoss(T boss, LootParams params, ServerLevel serverLevel) {
        if (((Boolean)TFConfig.COMMON_CONFIG.bossDropChests.get()).booleanValue()) {
            LootTable table = serverLevel.m_7654_().m_278653_().m_278676_(boss.m_5743_());
            ObjectArrayList stacks = table.m_287195_(params);
            ((IBossLootBuffer)boss).fill(boss, params, table);
            if (stacks.size() > 27) {
                for (ItemStack stack : stacks.subList(28, stacks.size())) {
                    ItemEntity item = new ItemEntity((Level)serverLevel, boss.m_20185_(), boss.m_20186_(), boss.m_20189_(), stack);
                    item.m_32064_();
                    item.m_32061_();
                    serverLevel.m_7967_((Entity)item);
                }
            }
        }
    }

    public static <T extends LivingEntity> void depositDropsIntoChest(T boss, BlockState chest, BlockPos pos, ServerLevel serverLevel) {
        BlockEntity blockEntity;
        if (((Boolean)TFConfig.COMMON_CONFIG.bossDropChests.get()).booleanValue() && (serverLevel.m_7731_(pos, chest, 2) || serverLevel.m_8055_(pos).m_60713_(chest.m_60734_())) && (blockEntity = serverLevel.m_7702_(pos)) instanceof Container) {
            Container container = (Container)blockEntity;
            for (int i = 0; i < 27 && i < container.m_6643_(); ++i) {
                container.m_6836_(i, ((IBossLootBuffer)boss).getItem(i));
            }
            Vec3 vec3 = Vec3.m_82512_((Vec3i)pos);
            serverLevel.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (SoundEvent)TFSounds.BOSS_CHEST_APPEAR.get(), boss.m_5720_(), 128.0f, (boss.m_217043_().m_188501_() - boss.m_217043_().m_188501_()) * 0.175f + 0.5f);
        }
    }

    default public <T extends LivingEntity> void fill(T boss, LootParams context, LootTable table) {
        ObjectArrayList items = table.m_287195_(context);
        RandomSource randomsource = boss.m_217043_();
        List<Integer> list = this.getAvailableSlots(randomsource);
        table.m_230924_(items, list.size(), randomsource);
        for (ItemStack itemstack : items) {
            if (list.isEmpty()) {
                return;
            }
            if (itemstack.m_41619_()) {
                this.setItem(list.remove(list.size() - 1), ItemStack.f_41583_);
                continue;
            }
            this.setItem(list.remove(list.size() - 1), itemstack);
        }
    }

    default public List<Integer> getAvailableSlots(RandomSource random) {
        ObjectArrayList arrayList = new ObjectArrayList();
        for (int i = 0; i < 27; ++i) {
            arrayList.add((Object)i);
        }
        Util.m_214673_((ObjectArrayList)arrayList, (RandomSource)random);
        return arrayList;
    }

    public NonNullList<ItemStack> getItemStacks();
}

