/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.TFGhastModel;
import twilightforest.entity.boss.UrGhast;

public class UrGhastModel
extends TFGhastModel<UrGhast> {
    private final ModelPart[][] tentacles = new ModelPart[9][4];

    public UrGhastModel(ModelPart root) {
        super(root);
        ModelPart body = root.m_171324_("body");
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i][0] = body.m_171324_("tentacle_" + i);
            this.tentacles[i][1] = this.tentacles[i][0].m_171324_("tentacle_" + i + "_extension");
            this.tentacles[i][2] = this.tentacles[i][1].m_171324_("tentacle_" + i + "_extension_2");
            this.tentacles[i][3] = this.tentacles[i][2].m_171324_("tentacle_" + i + "_tip");
        }
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partRoot = mesh.m_171576_();
        PartDefinition body = partRoot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        for (int i = 0; i < 9; ++i) {
            UrGhastModel.makeTentacle(body, "tentacle_" + i, i);
        }
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    protected static void makeTentacle(PartDefinition parent, String name, int iteration) {
        CubeListBuilder cubeListBuilder = CubeListBuilder.m_171558_().m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f);
        PartDefinition tentacleBase = parent.m_171599_(name, cubeListBuilder, switch (iteration) {
            case 0 -> PartPose.m_171419_((float)4.5f, (float)7.0f, (float)4.5f);
            case 1 -> PartPose.m_171419_((float)-4.5f, (float)7.0f, (float)4.5f);
            case 2 -> PartPose.m_171419_((float)0.0f, (float)7.0f, (float)0.0f);
            case 3 -> PartPose.m_171419_((float)5.5f, (float)7.0f, (float)-4.5f);
            case 4 -> PartPose.m_171419_((float)-5.5f, (float)7.0f, (float)-4.5f);
            case 5 -> PartPose.m_171423_((float)-7.5f, (float)3.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.7853982f);
            case 6 -> PartPose.m_171423_((float)-7.5f, (float)-1.5f, (float)3.5f, (float)0.0f, (float)0.0f, (float)1.0471976f);
            case 7 -> PartPose.m_171423_((float)7.5f, (float)3.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f);
            case 8 -> PartPose.m_171423_((float)7.5f, (float)-1.5f, (float)3.5f, (float)0.0f, (float)0.0f, (float)-1.0471976f);
            default -> {
                TwilightForestMod.LOGGER.warn("Out of bounds with Ur-Ghast Trophy limb creation: Iteration " + iteration);
                yield PartPose.f_171404_;
            }
        });
        PartDefinition tentacleExtension = tentacleBase.m_171599_(name + "_extension", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171481_(-1.5f, 1.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tentacleExtension2 = tentacleExtension.m_171599_(name + "_extension_2", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-1.5f, 1.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        tentacleExtension2.m_171599_(name + "_tip", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-1.5f, 1.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
    }

    @Override
    public void setupAnim(UrGhast entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        for (int i = 0; i < this.tentacles.length; ++i) {
            float wiggle = Math.min(limbSwingAmount, 0.6f);
            float time = (ageInTicks + (float)(i * 9)) / 2.0f;
            this.tentacles[i][0].f_104203_ = (Mth.m_14089_((float)(time * 0.6662f)) - 1.0471976f) * wiggle;
            this.tentacles[i][1].f_104203_ = Mth.m_14089_((float)(time * 0.7774f)) * 1.2f * wiggle;
            this.tentacles[i][2].f_104203_ = Mth.m_14089_((float)(time * 0.8886f + 1.5707964f)) * 1.4f * wiggle;
            this.tentacles[i][3].f_104203_ = Mth.m_14089_((float)(time * 0.9998f + 0.7853982f)) * 1.6f * wiggle;
            this.tentacles[i][0].f_104203_ = 0.2f + Mth.m_14089_((float)(time * 0.3335f)) * 0.15f;
            this.tentacles[i][1].f_104203_ = 0.1f + Mth.m_14089_((float)(time * 0.4445f)) * 0.2f;
            this.tentacles[i][2].f_104203_ = 0.1f + Mth.m_14089_((float)(time * 0.5555f)) * 0.25f;
            this.tentacles[i][3].f_104203_ = 0.1f + Mth.m_14089_((float)(time * 0.6665f)) * 0.3f;
            float yTwist = 0.4f;
            this.tentacles[i][0].f_104204_ = yTwist * Mth.m_14031_((float)(time * 0.3f));
        }
    }
}

