/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.capabilities.thrown;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import twilightforest.capabilities.thrown.YetiThrowCapability;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.ThrowPlayerPacket;
import twilightforest.network.UpdateThrownPacket;

public class YetiThrowCapabilityHandler
implements YetiThrowCapability {
    public static final int THROW_COOLDOWN = 200;
    private boolean thrown;
    private LivingEntity host;
    @Nullable
    private LivingEntity thrower;
    private int throwCooldown;
    private Vec3 throwVector = Vec3.f_82478_;

    @Override
    public void setEntity(LivingEntity entity) {
        this.host = entity;
    }

    @Override
    public void update() {
        Player player;
        LivingEntity livingEntity = this.host;
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            if (this.getThrown() && (player.m_20096_() || player.m_6069_() || player.m_20069_())) {
                this.setThrown(false, null);
            }
        }
        if (this.throwCooldown > 0) {
            if (!this.host.m_9236_().m_5776_() && this.throwCooldown == 199) {
                this.host.m_5997_(this.throwVector.m_7096_(), this.throwVector.m_7098_(), this.throwVector.m_7094_());
                livingEntity = this.host;
                if (livingEntity instanceof ServerPlayer) {
                    player = (ServerPlayer)livingEntity;
                    TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> YetiThrowCapabilityHandler.lambda$update$0((ServerPlayer)player)), (Object)new ThrowPlayerPacket(this.throwVector.m_7096_(), this.throwVector.m_7098_(), this.throwVector.m_7094_()));
                }
                this.throwVector = Vec3.f_82478_;
            }
            --this.throwCooldown;
        }
    }

    @Override
    public boolean getThrown() {
        return this.thrown;
    }

    @Override
    public void setThrown(boolean thrown, @Nullable LivingEntity thrower) {
        this.thrown = thrown;
        this.thrower = thrower;
        this.sendUpdatePacket();
    }

    @Override
    @Nullable
    public LivingEntity getThrower() {
        return this.thrower;
    }

    @Override
    public int getThrowCooldown() {
        return this.throwCooldown;
    }

    @Override
    public void setThrowCooldown(int cooldown) {
        this.throwCooldown = cooldown;
        this.sendUpdatePacket();
    }

    @Override
    public void setThrowVector(Vec3 vector) {
        this.throwVector = vector;
    }

    private void sendUpdatePacket() {
        if (!this.host.m_9236_().m_5776_()) {
            TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.host), (Object)new UpdateThrownPacket((Entity)this.host, (YetiThrowCapability)this));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("yetiThrown", this.getThrown());
        tag.m_128405_("throwCooldown", this.getThrowCooldown());
        tag.m_128347_("throwX", this.throwVector.m_7096_());
        tag.m_128347_("throwY", this.throwVector.m_7098_());
        tag.m_128347_("throwZ", this.throwVector.m_7094_());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setThrown(nbt.m_128471_("yetiThrown"), null);
        this.setThrowCooldown(nbt.m_128451_("throwCooldown"));
        this.throwVector = new Vec3(nbt.m_128459_("throwX"), nbt.m_128459_("throwY"), nbt.m_128459_("throwZ"));
    }

    private static /* synthetic */ ServerPlayer lambda$update$0(ServerPlayer player) {
        return player;
    }
}

