/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import twilightforest.TFConfig;
import twilightforest.block.SpecialMagicLogBlock;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFSounds;
import twilightforest.util.WorldUtil;

public class TransLogCoreBlock
extends SpecialMagicLogBlock {
    public TransLogCoreBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    public boolean doesCoreFunction() {
        return (Boolean)TFConfig.COMMON_CONFIG.MAGIC_TREES.disableTransformation.get() == false;
    }

    @Override
    void performTreeEffect(Level level, BlockPos pos, RandomSource rand) {
        ResourceKey<Biome> target = TFBiomes.ENCHANTED_FOREST;
        Holder.Reference biome = level.m_9598_().m_175515_(Registries.f_256952_).m_246971_(target);
        int range = (Integer)TFConfig.COMMON_CONFIG.MAGIC_TREES.transformationRange.get();
        for (int i = 0; i < 16; ++i) {
            BlockPos dPos = WorldUtil.randomOffset(rand, pos, range, 0, range);
            if (dPos.m_123331_((Vec3i)pos) > 256.0 || level.m_204166_(dPos).m_203565_(target)) continue;
            int minY = QuartPos.m_175400_((int)level.m_141937_());
            int maxY = minY + QuartPos.m_175400_((int)level.m_141928_()) - 1;
            int x = QuartPos.m_175400_((int)dPos.m_123341_());
            int z = QuartPos.m_175400_((int)dPos.m_123343_());
            LevelChunk chunkAt = level.m_6325_(dPos.m_123341_() >> 4, dPos.m_123343_() >> 4);
            for (LevelChunkSection section : chunkAt.m_7103_()) {
                for (int sy = 0; sy < 16; sy += 4) {
                    PalettedContainerRO palettedContainerRO;
                    int y = Mth.m_14045_((int)QuartPos.m_175400_((int)(chunkAt.m_151560_() + sy)), (int)minY, (int)maxY);
                    if (((Holder)section.m_187996_().m_63087_(x & 3, y & 3, z & 3)).m_203565_(target) || !((palettedContainerRO = section.m_187996_()) instanceof PalettedContainer)) continue;
                    PalettedContainer container = (PalettedContainer)palettedContainerRO;
                    container.m_156470_(x & 3, y & 3, z & 3, (Object)biome);
                }
            }
            if (!(level instanceof ServerLevel)) break;
            ServerLevel server = (ServerLevel)level;
            if (!chunkAt.m_6344_()) {
                chunkAt.m_8092_(true);
            }
            server.m_7726_().f_8325_.m_274524_(List.of(chunkAt));
            break;
        }
    }

    @Override
    protected void playSound(Level level, BlockPos pos, RandomSource rand) {
        level.m_5594_(null, pos, (SoundEvent)TFSounds.TRANSFORMATION_CORE.get(), SoundSource.BLOCKS, 0.1f, rand.m_188501_() * 2.0f);
    }
}

