/*
 * Decompiled with CFR 0.152.
 */
package com.drd.ad_extendra.client;

import com.drd.ad_extendra.client.models.entities.mobs.FreezeModel;
import com.drd.ad_extendra.client.models.entities.vehicles.CustomRocketModel;
import com.drd.ad_extendra.client.particles.WindParticle;
import com.drd.ad_extendra.client.renderers.blocks.CustomGlobeBlockEntityRenderer;
import com.drd.ad_extendra.client.renderers.blocks.CustomSlidingDoorBlockEntityRenderer;
import com.drd.ad_extendra.client.renderers.entities.mobs.FreezeRenderer;
import com.drd.ad_extendra.client.renderers.entities.vehicles.CustomBoatRenderer;
import com.drd.ad_extendra.client.renderers.entities.vehicles.CustomRocketRenderer;
import com.drd.ad_extendra.common.entities.vehicles.CustomBoat;
import com.drd.ad_extendra.common.registry.ModBlockEntityTypes;
import com.drd.ad_extendra.common.registry.ModBlocks;
import com.drd.ad_extendra.common.registry.ModEntityTypes;
import com.drd.ad_extendra.common.registry.ModItems;
import com.drd.ad_extendra.common.registry.ModParticleTypes;
import com.drd.ad_extendra.common.utils.ModWoodTypes;
import earth.terrarium.adastra.api.client.events.AdAstraClientEvents;
import earth.terrarium.adastra.client.ClientPlatformUtils;
import earth.terrarium.adastra.client.renderers.entities.vehicles.RocketRenderer;
import earth.terrarium.botarium.client.ClientHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;

public class AdExtendraClient {
    private static final List<AdAstraClientEvents.RenderSolarSystemEvent> RENDER_SOLAR_SYSTEM_LISTENERS = new ArrayList<AdAstraClientEvents.RenderSolarSystemEvent>();

    public static void init() {
        AdExtendraClient.registerEntityRenderers();
        AdExtendraClient.registerBlockEntityRenderers();
        AdExtendraClient.registerRenderLayers();
        AdExtendraClient.registerSheets();
    }

    private static void registerEntityRenderers() {
        ClientHooks.registerEntityRenderer(ModEntityTypes.FREEZE, FreezeRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.ICE_CHARGE, ThrownItemRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.BOAT, c -> new CustomBoatRenderer(c, false));
        ClientHooks.registerEntityRenderer(ModEntityTypes.CHEST_BOAT, c -> new CustomBoatRenderer(c, true));
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_5_ROCKET, c -> new RocketRenderer(c, CustomRocketModel.TIER_5_LAYER, CustomRocketRenderer.TIER_5_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_6_ROCKET, c -> new RocketRenderer(c, CustomRocketModel.TIER_6_LAYER, CustomRocketRenderer.TIER_6_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_7_ROCKET, c -> new RocketRenderer(c, CustomRocketModel.TIER_7_LAYER, CustomRocketRenderer.TIER_7_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_8_ROCKET, c -> new RocketRenderer(c, CustomRocketModel.TIER_8_LAYER, CustomRocketRenderer.TIER_8_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_9_ROCKET, c -> new RocketRenderer(c, CustomRocketModel.TIER_9_LAYER, CustomRocketRenderer.TIER_9_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_10_ROCKET, c -> new RocketRenderer(c, CustomRocketModel.TIER_10_LAYER, CustomRocketRenderer.TIER_10_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_11_ROCKET, c -> new RocketRenderer(c, CustomRocketModel.TIER_11_LAYER, CustomRocketRenderer.TIER_11_TEXTURE));
    }

    private static void registerBlockEntityRenderers() {
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.SLIDING_DOOR.get()), c -> new CustomSlidingDoorBlockEntityRenderer());
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.GLOBE.get()), c -> new CustomGlobeBlockEntityRenderer());
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.SIGN.get()), SignRenderer::new);
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.HANGING_SIGN.get()), HangingSignRenderer::new);
    }

    public static void registerRenderLayers() {
        ClientHooks.setRenderLayer((Block)((Block)ModBlocks.SATURN_ICE.get()), (RenderType)RenderType.m_110466_());
        ClientHooks.setRenderLayer((Block)((Block)ModBlocks.SLUSHY_ICE.get()), (RenderType)RenderType.m_110466_());
        ClientHooks.setRenderLayer((Block)((Block)ModBlocks.ICICLE.get()), (RenderType)RenderType.m_110457_());
        ClientHooks.setRenderLayer((Block)((Block)ModBlocks.GLACIAN_SAPLING.get()), (RenderType)RenderType.m_110457_());
        ClientHooks.setRenderLayer((Block)((Block)ModBlocks.POTTED_GLACIAN_SAPLING.get()), (RenderType)RenderType.m_110457_());
        ModBlocks.GLOBES.stream().forEach(block -> ClientHooks.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
    }

    public static void onRegisterEntityLayers(ClientPlatformUtils.LayerDefinitionRegistry consumer) {
        consumer.register(FreezeModel.LAYER_LOCATION, FreezeModel::createBodyLayer);
        for (CustomBoat.Type type : CustomBoat.Type.values()) {
            consumer.register(CustomBoatRenderer.boatTextureLocation(type), BoatModel::m_246613_);
            consumer.register(CustomBoatRenderer.chestBoatTextureLocation(type), ChestBoatModel::m_247175_);
        }
        CustomRocketModel.register(consumer);
    }

    public static void onRegisterModels(Consumer<ResourceLocation> consumer) {
        ModBlocks.GLOBES.stream().forEach(b -> consumer.accept(new ResourceLocation("ad_extendra", "block/%s_cube".formatted(b.getId().m_135815_()))));
    }

    public static void onRegisterItemRenderers(BiConsumer<Item, BlockEntityWithoutLevelRenderer> consumer) {
        consumer.accept((Item)ModItems.TIER_5_ROCKET.get(), (BlockEntityWithoutLevelRenderer)new RocketRenderer.ItemRenderer(CustomRocketModel.TIER_5_LAYER, CustomRocketRenderer.TIER_5_TEXTURE));
        consumer.accept((Item)ModItems.TIER_6_ROCKET.get(), (BlockEntityWithoutLevelRenderer)new RocketRenderer.ItemRenderer(CustomRocketModel.TIER_6_LAYER, CustomRocketRenderer.TIER_6_TEXTURE));
        consumer.accept((Item)ModItems.TIER_7_ROCKET.get(), (BlockEntityWithoutLevelRenderer)new RocketRenderer.ItemRenderer(CustomRocketModel.TIER_7_LAYER, CustomRocketRenderer.TIER_7_TEXTURE));
        consumer.accept((Item)ModItems.TIER_8_ROCKET.get(), (BlockEntityWithoutLevelRenderer)new RocketRenderer.ItemRenderer(CustomRocketModel.TIER_8_LAYER, CustomRocketRenderer.TIER_8_TEXTURE));
        consumer.accept((Item)ModItems.TIER_9_ROCKET.get(), (BlockEntityWithoutLevelRenderer)new RocketRenderer.ItemRenderer(CustomRocketModel.TIER_9_LAYER, CustomRocketRenderer.TIER_9_TEXTURE));
        consumer.accept((Item)ModItems.TIER_10_ROCKET.get(), (BlockEntityWithoutLevelRenderer)new RocketRenderer.ItemRenderer(CustomRocketModel.TIER_10_LAYER, CustomRocketRenderer.TIER_10_TEXTURE));
        consumer.accept((Item)ModItems.TIER_11_ROCKET.get(), (BlockEntityWithoutLevelRenderer)new RocketRenderer.ItemRenderer(CustomRocketModel.TIER_11_LAYER, CustomRocketRenderer.TIER_11_TEXTURE));
        ModItems.GLOBES.stream().forEach(item -> consumer.accept((Item)item.get(), new CustomGlobeBlockEntityRenderer.ItemRenderer()));
    }

    public static void onRegisterParticles(BiConsumer<ParticleType<SimpleParticleType>, ClientPlatformUtils.SpriteParticleRegistration<SimpleParticleType>> consumer) {
        consumer.accept((ParticleType<SimpleParticleType>)((ParticleType)ModParticleTypes.WIND.get()), (ClientPlatformUtils.SpriteParticleRegistration<SimpleParticleType>)((ClientPlatformUtils.SpriteParticleRegistration)WindParticle.Provider::new));
    }

    private static void registerSheets() {
        AdExtendraClient.addWoodType(ModWoodTypes.AERONOS);
        AdExtendraClient.addWoodType(ModWoodTypes.STROPHAR);
        AdExtendraClient.addWoodType(ModWoodTypes.GLACIAN);
    }

    private static void addWoodType(WoodType woodType) {
        ResourceLocation location = new ResourceLocation(woodType.f_61839_());
        Sheets.f_110743_.put(woodType, new Material(Sheets.f_110739_, new ResourceLocation("ad_extendra", "entity/signs/" + location.m_135815_())));
        Sheets.f_244291_.put(woodType, new Material(Sheets.f_110739_, new ResourceLocation("ad_extendra", "entity/signs/hanging/" + location.m_135815_())));
    }

    static void register(AdAstraClientEvents.RenderSolarSystemEvent listener) {
        RENDER_SOLAR_SYSTEM_LISTENERS.add(listener);
    }
}

