/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.network.messages;

import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ExtraByteCodecs;
import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import earth.terrarium.adastra.common.handlers.LaunchingDimensionHandler;
import earth.terrarium.adastra.common.network.CodecPacketType;
import earth.terrarium.adastra.common.utils.ModUtils;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record ServerboundLandPacket(ResourceKey<Level> dimension, boolean tryPreviousLocation) implements Packet<ServerboundLandPacket>
{
    public static final ServerboundPacketType<ServerboundLandPacket> TYPE = new Type();

    public PacketType<ServerboundLandPacket> type() {
        return TYPE;
    }

    private static class Type
    extends CodecPacketType<ServerboundLandPacket>
    implements ServerboundPacketType<ServerboundLandPacket> {
        public Type() {
            super(ServerboundLandPacket.class, new ResourceLocation("ad_astra", "land"), ObjectByteCodec.create((ObjectEntryByteCodec)ExtraByteCodecs.DIMENSION.fieldOf(ServerboundLandPacket::dimension), (ObjectEntryByteCodec)ByteCodec.BOOLEAN.fieldOf(ServerboundLandPacket::tryPreviousLocation), ServerboundLandPacket::new));
        }

        public Consumer<Player> handle(ServerboundLandPacket packet) {
            return player -> {
                ServerLevel targetLevel;
                Level patt2429$temp = player.m_9236_();
                if (!(patt2429$temp instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)patt2429$temp;
                Planet planet = PlanetApi.API.getPlanet(packet.dimension);
                if (planet == null) {
                    return;
                }
                if (planet.isSpace()) {
                    return;
                }
                if (!ModUtils.canTeleportToPlanet(player, planet)) {
                    return;
                }
                boolean landingNormally = packet.tryPreviousLocation() && player.m_20202_() instanceof Rocket;
                GlobalPos newPos = landingNormally ? (GlobalPos)LaunchingDimensionHandler.getSpawningLocation(player, serverLevel, planet).orElse(null) : null;
                MinecraftServer server = serverLevel.m_7654_();
                ServerLevel serverLevel2 = targetLevel = newPos == null ? server.m_129880_(planet.dimension()) : server.m_129880_(newPos.m_122640_());
                if (targetLevel == null) {
                    throw new IllegalStateException(String.format("Dimension %s does not exist! Try restarting your %s!", planet.dimension(), server.m_6982_() ? "server" : "singleplayer world"));
                }
                LaunchingDimensionHandler.addSpawnLocation(player, serverLevel);
                BlockPos targetPos = newPos != null ? newPos.m_122646_() : player.m_20183_();
                ModUtils.land((ServerPlayer)player, targetLevel, new Vec3((double)targetPos.m_123341_(), (double)AdAstraConfig.atmosphereLeave, (double)targetPos.m_123343_()));
            };
        }
    }
}

