/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.network.messages;

import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ExtraByteCodecs;
import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.common.compat.cadmus.CadmusIntegration;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.handlers.LaunchingDimensionHandler;
import earth.terrarium.adastra.common.handlers.SpaceStationHandler;
import earth.terrarium.adastra.common.network.CodecPacketType;
import earth.terrarium.adastra.common.recipes.SpaceStationRecipe;
import earth.terrarium.adastra.common.utils.ModUtils;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;

public record ServerboundConstructSpaceStationPacket(ResourceKey<Level> dimension, Component name) implements Packet<ServerboundConstructSpaceStationPacket>
{
    public static final ServerboundPacketType<ServerboundConstructSpaceStationPacket> TYPE = new Type();

    public PacketType<ServerboundConstructSpaceStationPacket> type() {
        return TYPE;
    }

    private static class Type
    extends CodecPacketType<ServerboundConstructSpaceStationPacket>
    implements ServerboundPacketType<ServerboundConstructSpaceStationPacket> {
        public Type() {
            super(ServerboundConstructSpaceStationPacket.class, new ResourceLocation("ad_astra", "construct_space_station"), ObjectByteCodec.create((ObjectEntryByteCodec)ExtraByteCodecs.DIMENSION.fieldOf(ServerboundConstructSpaceStationPacket::dimension), (ObjectEntryByteCodec)ExtraByteCodecs.COMPONENT.fieldOf(ServerboundConstructSpaceStationPacket::name), ServerboundConstructSpaceStationPacket::new));
        }

        public Consumer<Player> handle(ServerboundConstructSpaceStationPacket packet) {
            return player -> {
                Level patt2945$temp = player.m_9236_();
                if (!(patt2945$temp instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)patt2945$temp;
                if (!(player instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Planet planet = PlanetApi.API.getPlanet(packet.dimension);
                if (planet == null) {
                    return;
                }
                ServerLevel targetLevel = serverLevel.m_7654_().m_129880_(planet.orbitIfPresent());
                if (targetLevel == null) {
                    return;
                }
                if (!PlanetApi.API.isSpace((Level)targetLevel)) {
                    return;
                }
                if (!ModUtils.canTeleportToPlanet(player, planet)) {
                    return;
                }
                if (CadmusIntegration.cadmusLoaded() && CadmusIntegration.isClaimed(targetLevel, player.m_146902_())) {
                    return;
                }
                SpaceStationRecipe recipe = SpaceStationRecipe.getSpaceStation((Level)targetLevel, (ResourceKey<Level>)targetLevel.m_46472_()).orElse(null);
                if (recipe == null) {
                    return;
                }
                if (SpaceStationHandler.isInSpaceStation(serverPlayer, targetLevel)) {
                    return;
                }
                if (!SpaceStationRecipe.hasIngredients((Player)serverPlayer, (Level)targetLevel, recipe)) {
                    return;
                }
                SpaceStationRecipe.consumeIngredients((Player)serverPlayer, (Level)targetLevel);
                ChunkPos pos = player.m_146902_();
                StructureTemplate structure = targetLevel.m_215082_().m_230359_(recipe.structure());
                BlockPos stationPos = BlockPos.m_274561_((double)((float)pos.m_151390_() - (float)structure.m_163801_().m_123341_() / 2.0f), (double)100.0, (double)((float)pos.m_151393_() - (float)structure.m_163801_().m_123343_() / 2.0f));
                targetLevel.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(stationPos), 1, (Object)stationPos);
                structure.m_230328_((ServerLevelAccessor)targetLevel, stationPos, stationPos, new StructurePlaceSettings(), targetLevel.f_46441_, 2);
                SpaceStationHandler.constructSpaceStation(serverPlayer, targetLevel, packet.name);
                LaunchingDimensionHandler.addSpawnLocation(player, serverLevel);
                BlockPos middleBlockPosition = pos.m_151394_(AdAstraConfig.atmosphereLeave);
                ModUtils.land(serverPlayer, targetLevel, new Vec3((double)((float)middleBlockPosition.m_123341_() - 0.5f), (double)middleBlockPosition.m_123342_(), (double)((float)middleBlockPosition.m_123343_() - 0.5f)));
                if (CadmusIntegration.cadmusLoaded()) {
                    for (int i = -1; i < 2; ++i) {
                        for (int j = -1; j < 2; ++j) {
                            CadmusIntegration.claim(serverPlayer, new ChunkPos(pos.f_45578_ + i, pos.f_45579_ + j));
                        }
                    }
                }
            };
        }
    }
}

