/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.items;

import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidItem;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedItemFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GasTankItem
extends Item
implements BotariumFluidItem<WrappedItemFluidContainer> {
    private final long tankSize;
    private final long distributionAmount;

    public GasTankItem(Item.Properties properties, long tankSize, long distributionAmount) {
        super(properties);
        this.tankSize = tankSize;
        this.distributionAmount = distributionAmount;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (FluidUtils.hasFluid(stack)) {
            player.m_6672_(usedHand);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity entity, @NotNull ItemStack stack, int remainingUseDuration) {
        if (level.m_5776_()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Inventory inventory = player.m_150109_();
        FluidHolder container = FluidUtils.getTank(stack);
        if (container.getFluidAmount() == 0L) {
            return;
        }
        ItemStackHolder from = new ItemStackHolder(stack);
        if (!this.distributeSequential(from, container, inventory)) {
            return;
        }
        inventory.m_6836_(inventory.f_35977_, from.getStack());
        if (entity.f_19797_ % 4 == 0) {
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11911_, player.m_5720_(), 1.0f, 1.0f);
        }
    }

    public boolean distributeSequential(ItemStackHolder from, FluidHolder container, Inventory inventory) {
        for (int i = inventory.m_6643_() - 1; i >= 0; --i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || stack.m_150930_((Item)this)) continue;
            ItemStackHolder to = new ItemStackHolder(stack);
            long moved = FluidApi.moveFluid((ItemStackHolder)from, (ItemStackHolder)to, (FluidHolder)container.copyWithAmount(FluidConstants.fromMillibuckets((long)this.distributionAmount)), (boolean)false);
            inventory.m_6836_(i, to.getStack());
            if (moved <= 0L) continue;
            return true;
        }
        return false;
    }

    public WrappedItemFluidContainer getFluidContainer(ItemStack holder) {
        return new WrappedItemFluidContainer(holder, (FluidContainer)new SimpleFluidContainer(FluidConstants.fromMillibuckets((long)this.tankSize), 1, (t, f) -> true));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add(TooltipUtils.getFluidComponent(FluidUtils.getTank(stack), FluidUtils.getTankCapacity(stack)));
        tooltipComponents.add(TooltipUtils.getMaxFluidOutComponent(FluidConstants.fromMillibuckets((long)this.distributionAmount)));
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.GAS_TANK_INFO);
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return FluidUtils.hasFluid(stack);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        WrappedItemFluidContainer fluidContainer = this.getFluidContainer(stack);
        return (int)((double)fluidContainer.getFirstFluid().getFluidAmount() / (double)fluidContainer.getTankCapacity(0) * 13.0);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return ClientFluidHooks.getFluidColor((FluidHolder)FluidUtils.getTank(stack));
    }
}

