/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blocks.properties;

import java.util.List;
import java.util.Locale;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.jetbrains.annotations.NotNull;

public class EightDirectionProperty
extends EnumProperty<Direction> {
    public static final EightDirectionProperty FACING = new EightDirectionProperty();

    public EightDirectionProperty() {
        super("facing", Direction.class, List.of(Direction.VALUES));
    }

    public static enum Direction implements StringRepresentable
    {
        NORTH(new Vec3i(0, 0, -1)),
        NORTH_EAST(new Vec3i(1, 0, -1)),
        EAST(new Vec3i(1, 0, 0)),
        SOUTH_EAST(new Vec3i(1, 0, 1)),
        SOUTH(new Vec3i(0, 0, 1)),
        SOUTH_WEST(new Vec3i(-1, 0, 1)),
        WEST(new Vec3i(-1, 0, 0)),
        NORTH_WEST(new Vec3i(-1, 0, -1));

        private final Vec3i normal;
        public static final Direction[] VALUES;

        private Direction(Vec3i normal) {
            this.normal = normal;
        }

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.m_7912_();
        }

        public Vec3i normal() {
            return this.normal;
        }

        public Direction mirror(Mirror mirror) {
            return switch (mirror) {
                default -> throw new IncompatibleClassChangeError();
                case Mirror.NONE -> this;
                case Mirror.FRONT_BACK -> this.rotate(Rotation.CLOCKWISE_180);
                case Mirror.LEFT_RIGHT -> {
                    switch (this) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case NORTH: {
                            yield SOUTH;
                        }
                        case SOUTH: {
                            yield NORTH;
                        }
                        case WEST: {
                            yield WEST;
                        }
                        case EAST: {
                            yield EAST;
                        }
                        case NORTH_EAST: {
                            yield SOUTH_EAST;
                        }
                        case SOUTH_EAST: {
                            yield NORTH_EAST;
                        }
                        case SOUTH_WEST: {
                            yield NORTH_WEST;
                        }
                        case NORTH_WEST: 
                    }
                    yield SOUTH_WEST;
                }
            };
        }

        public Direction rotate(Rotation rotation) {
            return switch (rotation) {
                case Rotation.CLOCKWISE_180 -> {
                    switch (this) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case NORTH: {
                            yield SOUTH;
                        }
                        case SOUTH: {
                            yield NORTH;
                        }
                        case EAST: {
                            yield WEST;
                        }
                        case WEST: {
                            yield EAST;
                        }
                        case NORTH_EAST: {
                            yield SOUTH_WEST;
                        }
                        case SOUTH_WEST: {
                            yield NORTH_EAST;
                        }
                        case NORTH_WEST: {
                            yield SOUTH_EAST;
                        }
                        case SOUTH_EAST: 
                    }
                    yield NORTH_WEST;
                }
                case Rotation.COUNTERCLOCKWISE_90 -> {
                    switch (this) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case NORTH: {
                            yield NORTH_EAST;
                        }
                        case SOUTH: {
                            yield SOUTH_WEST;
                        }
                        case EAST: {
                            yield SOUTH_EAST;
                        }
                        case WEST: {
                            yield NORTH_WEST;
                        }
                        case NORTH_EAST: {
                            yield EAST;
                        }
                        case SOUTH_WEST: {
                            yield WEST;
                        }
                        case NORTH_WEST: {
                            yield NORTH;
                        }
                        case SOUTH_EAST: 
                    }
                    yield SOUTH;
                }
                case Rotation.CLOCKWISE_90 -> {
                    switch (this) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case NORTH: {
                            yield NORTH_WEST;
                        }
                        case SOUTH: {
                            yield SOUTH_EAST;
                        }
                        case EAST: {
                            yield NORTH_EAST;
                        }
                        case WEST: {
                            yield SOUTH_WEST;
                        }
                        case NORTH_EAST: {
                            yield NORTH;
                        }
                        case SOUTH_WEST: {
                            yield SOUTH;
                        }
                        case NORTH_WEST: {
                            yield WEST;
                        }
                        case SOUTH_EAST: 
                    }
                    yield EAST;
                }
                default -> this;
            };
        }

        public int asRotation() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORTH -> 0;
                case NORTH_WEST -> 45;
                case WEST -> 90;
                case SOUTH_WEST -> 135;
                case SOUTH -> 180;
                case SOUTH_EAST -> 225;
                case EAST -> 270;
                case NORTH_EAST -> 315;
            };
        }

        static {
            VALUES = Direction.values();
        }
    }
}

