/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.base.sideconfig;

import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public record ConfigurationEntry(ConfigurationType type, EnumMap<Direction, Configuration> sides, Component title) {
    public ConfigurationEntry(ConfigurationType type, Configuration defaultValue, Component title) {
        this(type, ConfigurationEntry.createConfiguration(defaultValue), title);
    }

    public Configuration get(Direction direction) {
        return this.sides.get(direction);
    }

    public void set(Direction direction, Configuration value) {
        this.sides.replace(direction, value);
    }

    public ConfigurationEntry copy() {
        return new ConfigurationEntry(this.type, new EnumMap<Direction, Configuration>(this.sides), this.title);
    }

    public static void save(CompoundTag tag, List<ConfigurationEntry> sideConfig) {
        ListTag list = new ListTag();
        for (ConfigurationEntry entry : sideConfig) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128344_("Type", (byte)entry.type.ordinal());
            entry.sides.forEach((direction, configuration) -> entryTag.m_128344_(direction.m_122433_(), (byte)configuration.ordinal()));
            list.add((Object)entryTag);
        }
        tag.m_128365_("SideConfig", (Tag)list);
    }

    public static void load(CompoundTag tag, List<ConfigurationEntry> sideConfig, List<ConfigurationEntry> defaultConfig) {
        ListTag list = tag.m_128437_("SideConfig", 10);
        sideConfig.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entryTag = list.m_128728_(i);
            ConfigurationType type = ConfigurationType.values()[entryTag.m_128445_("Type")];
            EnumMap<Direction, Configuration> sides = new EnumMap<Direction, Configuration>(Direction.class);
            for (Direction direction : Direction.values()) {
                sides.put(direction, Configuration.values()[entryTag.m_128445_(direction.m_122433_())]);
            }
            sideConfig.add(new ConfigurationEntry(type, sides, defaultConfig.get(i).title()));
        }
    }

    private static EnumMap<Direction, Configuration> createConfiguration(Configuration value) {
        EnumMap<Direction, Configuration> configurations = new EnumMap<Direction, Configuration>(Direction.class);
        for (Direction direction : Direction.values()) {
            configurations.put(direction, value);
        }
        return configurations;
    }
}

