/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.base;

import earth.terrarium.adastra.common.blockentities.base.BasicContainer;
import earth.terrarium.adastra.common.blockentities.base.MachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.RedstoneControl;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.SideConfigurable;
import earth.terrarium.botarium.common.menu.ExtraDataMenuProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerMachineBlockEntity
extends MachineBlockEntity
implements BasicContainer,
WorldlyContainer,
ExtraDataMenuProvider,
SideConfigurable {
    private final List<ConfigurationEntry> sideConfig = new ArrayList<ConfigurationEntry>();
    private final NonNullList<ItemStack> items;
    private RedstoneControl redstoneControl = RedstoneControl.ALWAYS_ON;

    public ContainerMachineBlockEntity(BlockPos pos, BlockState state, int containerSize) {
        super(pos, state);
        this.items = NonNullList.m_122780_((int)containerSize, (Object)ItemStack.f_41583_);
    }

    @Override
    public void firstTick(Level level, BlockPos pos, BlockState state) {
        super.firstTick(level, pos, state);
        this.update();
    }

    @Override
    public void internalServerTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        if (time % 50L == 0L && this.shouldUpdate()) {
            this.update();
        }
        if (this.canFunction()) {
            this.tickSideInteractions(pos, f -> true, this.getSideConfig());
        }
    }

    public boolean shouldUpdate() {
        return true;
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        ConfigurationEntry.load(tag, this.sideConfig, this.getDefaultConfig());
        this.redstoneControl = RedstoneControl.values()[tag.m_128445_("RedstoneControl")];
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        ConfigurationEntry.save(tag, this.sideConfig);
        tag.m_128344_("RedstoneControl", (byte)this.redstoneControl.ordinal());
    }

    public void writeExtraData(ServerPlayer player, FriendlyByteBuf buffer) {
        buffer.m_130064_(this.m_58899_());
    }

    public boolean m_6542_(@NotNull Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    @NotNull
    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Override
    public NonNullList<ItemStack> items() {
        return this.items;
    }

    public boolean canFunction() {
        return this.getRedstoneControl().canPower(this.isRedstonePowered());
    }

    @Override
    public List<ConfigurationEntry> getSideConfig() {
        if (this.sideConfig.isEmpty()) {
            this.sideConfig.addAll(this.createDefaultConfig());
        }
        return this.sideConfig;
    }

    public void tickSideInteractions(BlockPos pos, Predicate<Direction> filter, List<ConfigurationEntry> sideConfig) {
    }

    public RedstoneControl getRedstoneControl() {
        return this.redstoneControl;
    }

    public void setRedstoneControl(RedstoneControl redstoneControl) {
        this.redstoneControl = redstoneControl;
        this.m_6596_();
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return true;
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return true;
    }
}

