/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.renderers.ti69;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import earth.terrarium.adastra.client.renderers.ti69.apps.Ti69App;
import earth.terrarium.adastra.common.items.Ti69Item;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.joml.Matrix4f;

public class Ti69Renderer {
    public static final ResourceLocation TEXTURE = new ResourceLocation("ad_astra", "textures/ti-69/ti-69.png");
    public static final ResourceLocation SCREEN = new ResourceLocation("ad_astra", "textures/ti-69/screen.png");
    public static final ResourceLocation OVERLAY = new ResourceLocation("ad_astra", "textures/ti-69/overlay.png");
    public static final ResourceLocation ICONS = new ResourceLocation("ad_astra", "textures/ti-69/icons.png");

    public static void renderTi69(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, float equippedProgress, HumanoidArm hand, float swingProgress, ArmRenderer armRenderer) {
        boolean rightHanded = hand == HumanoidArm.RIGHT;
        float f = rightHanded ? 1.0f : -1.0f;
        poseStack.m_252880_(f * 0.125f, -0.125f, 0.0f);
        assert (Minecraft.m_91087_().f_91074_ != null);
        if (!Minecraft.m_91087_().f_91074_.m_20145_()) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252403_.m_252977_(f * 10.0f));
            armRenderer.renderPlayerArm(poseStack, buffer, combinedLight, equippedProgress, swingProgress, hand);
            poseStack.m_85849_();
        }
        try (CloseablePoseStack pose = new CloseablePoseStack(poseStack);){
            pose.m_252880_(f * 0.51f, -0.1f + equippedProgress * -1.2f, -0.75f);
            float g = Mth.m_14116_((float)swingProgress);
            float h = Mth.m_14031_((float)(g * (float)Math.PI));
            float i = -0.5f * h;
            float j = 0.4f * Mth.m_14031_((float)(g * ((float)Math.PI * 2)));
            float k = -0.3f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
            pose.m_252880_(f * i, j * h, k);
            pose.m_252781_(Axis.f_252529_.m_252977_(h * -45.0f));
            pose.m_252781_(Axis.f_252436_.m_252977_(f * h * -30.0f));
            float moveAmount = hand == HumanoidArm.RIGHT ? 0.1f : 0.09f;
            pose.m_252880_(moveAmount, 0.0f, 0.0f);
            Ti69Renderer.renderTi69((PoseStack)pose, buffer, combinedLight, rightHanded);
        }
    }

    public static void renderTi69(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, boolean rightHanded) {
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_252880_(-0.5f, -0.75f, 0.0f);
        poseStack.m_85841_(0.0078125f, 0.0078125f, 0.0078125f);
        poseStack.m_85841_(0.6f, 1.06f, 1.0f);
        VertexConsumer vertex = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)TEXTURE));
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        vertex.m_252986_(matrix4f, -7.0f, 135.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(combinedLight).m_5752_();
        vertex.m_252986_(matrix4f, 135.0f, 135.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(combinedLight).m_5752_();
        vertex.m_252986_(matrix4f, 135.0f, -7.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(combinedLight).m_5752_();
        vertex.m_252986_(matrix4f, -7.0f, -7.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(combinedLight).m_5752_();
        Ti69App app = Ti69Item.APP;
        Ti69Renderer.texture(poseStack, buffer, app.color(), 0.01f, SCREEN);
        try (CloseablePoseStack pose = new CloseablePoseStack(poseStack);){
            pose.m_85841_(1.2f, 0.7f, 0.7f);
            pose.m_252880_(15.0f, 25.0f, 0.0f);
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            app.render((PoseStack)pose, buffer, pose.m_85850_().m_252922_(), Minecraft.m_91087_().f_91062_, level, rightHanded);
        }
        Ti69Renderer.texture(poseStack, buffer, -1, -0.01f, OVERLAY);
    }

    private static void texture(PoseStack poseStack, MultiBufferSource buffer, int color, float z, ResourceLocation overlay) {
        try (CloseablePoseStack pose = new CloseablePoseStack(poseStack);){
            pose.m_85841_(0.95f, 0.392f, 1.0f);
            pose.m_252880_(21.0f, 48.0f, z);
            VertexConsumer screenVertex = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)overlay));
            Matrix4f matrix4f = pose.m_85850_().m_252922_();
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            screenVertex.m_252986_(matrix4f, -7.0f, 100.0f, 0.0f).m_6122_(red, green, blue, 255).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
            screenVertex.m_252986_(matrix4f, 100.0f, 100.0f, 0.0f).m_6122_(red, green, blue, 255).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
            screenVertex.m_252986_(matrix4f, 100.0f, -7.0f, 0.0f).m_6122_(red, green, blue, 255).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
            screenVertex.m_252986_(matrix4f, -7.0f, -7.0f, 0.0f).m_6122_(red, green, blue, 255).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        }
    }

    @FunctionalInterface
    public static interface ArmRenderer {
        public void renderPlayerArm(PoseStack var1, MultiBufferSource var2, int var3, float var4, float var5, HumanoidArm var6);
    }
}

