/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.renderers.blocks;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import earth.terrarium.adastra.client.renderers.textures.FlagImageTexture;
import earth.terrarium.adastra.client.renderers.textures.FlagUrlTexture;
import earth.terrarium.adastra.common.blockentities.flag.FlagBlockEntity;
import earth.terrarium.adastra.common.blockentities.flag.content.FlagContent;
import earth.terrarium.adastra.common.blockentities.flag.content.ImageContent;
import earth.terrarium.adastra.common.blockentities.flag.content.UrlContent;
import earth.terrarium.adastra.common.blocks.FlagBlock;
import earth.terrarium.adastra.common.blocks.properties.EightDirectionProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class FlagBlockEntityRenderer
implements BlockEntityRenderer<FlagBlockEntity> {
    public void render(FlagBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState state = entity.m_58900_();
        EightDirectionProperty.Direction direction = (EightDirectionProperty.Direction)((Object)state.m_61143_((Property)FlagBlock.FACING));
        Minecraft minecraft = Minecraft.m_91087_();
        try (CloseablePoseStack pose = new CloseablePoseStack(poseStack);){
            pose.m_85837_(0.5, 0.5, 0.5);
            pose.m_252781_(Axis.f_252436_.m_252977_((float)direction.asRotation()));
            pose.m_85837_(-0.5, 0.0, -0.5);
            if (((DoubleBlockHalf)state.m_61143_(FlagBlock.HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
                BakedModel model = minecraft.m_91289_().m_110910_(state);
                minecraft.m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), buffer.m_6299_(Sheets.m_110790_()), state, model, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
            } else {
                FlagContent content = entity.getContent();
                if (content == null) {
                    pose.m_85837_(-0.75, 0.19, 0.495);
                    pose.m_85841_(1.0f, 1.0f, 0.00625f);
                    SkullModel model = new SkullModel(minecraft.m_167973_().m_171103_(ModelLayers.f_171163_));
                    RenderType renderType = SkullBlockRenderer.m_112523_((SkullBlock.Type)SkullBlock.Types.PLAYER, (GameProfile)entity.getOwner());
                    SkullBlockRenderer.m_173663_(null, (float)0.0f, (float)0.0f, (PoseStack)pose, (MultiBufferSource)buffer, (int)packedLight, (SkullModelBase)model, (RenderType)renderType);
                    pose.m_85837_(0.5, 0.0, 0.5);
                    pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    pose.m_85837_(-0.5, 0.0, -0.5);
                    pose.m_252880_(0.0f, 0.0f, -1.0f);
                    SkullBlockRenderer.m_173663_(null, (float)0.0f, (float)0.0f, (PoseStack)pose, (MultiBufferSource)buffer, (int)packedLight, (SkullModelBase)model, (RenderType)renderType);
                } else {
                    VertexConsumer consumer = buffer.m_6299_(FlagBlockEntityRenderer.getFlagImage(content));
                    Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                    Matrix3f matrix3fNormal = poseStack.m_85850_().m_252943_();
                    Vec3i normal = direction.normal();
                    pose.m_85837_(0.5, 0.0, 0.5);
                    pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                    pose.m_85837_(-0.5, 0.0, -0.5);
                    pose.m_85841_(1.3625f, 1.0f, 1.0f);
                    pose.m_85837_(-0.6875, -0.9375, 0.495);
                    FlagBlockEntityRenderer.renderQuad(matrix4f, matrix3fNormal, normal, consumer, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, packedOverlay);
                    pose.m_85837_(0.5, 0.0, 0.5);
                    pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    pose.m_85837_(-0.5, 0.0, -0.5);
                    pose.m_85837_(0.0, 0.0, 0.99);
                    FlagBlockEntityRenderer.renderQuad(matrix4f, matrix3fNormal, normal, consumer, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, packedOverlay);
                }
            }
        }
    }

    private static void renderQuad(Matrix4f pose, Matrix3f matrix3fNormal, Vec3i normal, VertexConsumer consumer, float width, float height, float u, float v, float uWidth, float vHeight, int light, int overlay) {
        consumer.m_252986_(pose, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(overlay).m_85969_(light).m_252939_(matrix3fNormal, (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        consumer.m_252986_(pose, 0.0f, height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u, v + vHeight).m_86008_(overlay).m_85969_(light).m_252939_(matrix3fNormal, (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        consumer.m_252986_(pose, width, height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u + uWidth, v + vHeight).m_86008_(overlay).m_85969_(light).m_252939_(matrix3fNormal, (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        consumer.m_252986_(pose, width, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u + uWidth, v).m_86008_(overlay).m_85969_(light).m_252939_(matrix3fNormal, (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }

    private static RenderType getFlagImage(FlagContent content) {
        ResourceLocation id = content.toTexture();
        TextureManager manager = Minecraft.m_91087_().m_91097_();
        AbstractTexture texture = manager.m_174786_(id, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
        if (texture == MissingTextureAtlasSprite.m_118080_()) {
            if (content instanceof UrlContent) {
                UrlContent url = (UrlContent)content;
                manager.m_118495_(id, (AbstractTexture)new FlagUrlTexture(url.url()));
            } else if (content instanceof ImageContent) {
                ImageContent image = (ImageContent)content;
                manager.m_118495_(id, (AbstractTexture)new FlagImageTexture(image.data()));
            }
        }
        return RenderType.m_110446_((ResourceLocation)id);
    }
}

